//Author:    Timothy Pearson <kb9vqf@pearsoncomputing.net>, (C) 2012
//Copyright: See COPYING file that comes with this distribution

#ifndef INSTRUMENTVIEW_H
#define INSTRUMENTVIEW_H

#include <tdeconfig.h>
#include <tdeparts/part.h>
#include <tdemdichildview.h>

#include <tqtrla.h>

class TDEAction;

namespace RemoteLab {

typedef KParts::RemoteInstrumentPart InstrumentPart;

class InstrumentView : public KMdiChildView
{
	Q_OBJECT
	
	public:
		InstrumentView(const TQString &library, TQWidget *parentWidget=0L, const char *name=0L, WFlags f=0);
		InstrumentView(const TQString &library, const TQString &caption, TQWidget *parentWidget=0L, const char *name=0L, WFlags f=0);
		~InstrumentView();
		void connectServer(TQString server);
		void closeConnections();

		TQPtrList<TDEAction> menuActionList();
	
	protected:
		virtual void saveProperties(TDEConfig *);
		virtual void readProperties(TDEConfig *);
		virtual bool queryExit();
		virtual void resizeEvent(TQResizeEvent *);
		virtual bool eventFilter(TQObject *o, TQEvent *e);

	private slots:
		void setStatusMessage(const TQString& message);
		void setUsingFixedSize(bool fixed);
		void setChildSizeData();

	signals:
		void statusMessageSet(const TQString&);
	
	private:
		void init();
		KMdiMainFrm* m_mainForm;
		TQString m_libraryName;
		RemoteLab::InstrumentPart *m_instrumentPart;
		bool m_fixedSize;
		bool* m_canary;
};

} // namespace RemoteLab

#endif
