/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <tdelocale.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <knuminput.h>
#include <tdeactionselector.h>
#include <tqlistbox.h>
#include <kpushbutton.h>
#include <tqpixmap.h>
#include <tqiconset.h>
#include <tqlabel.h>
#include <tdeconfig.h>
#include <tqcheckbox.h>
#include <tqradiobutton.h>

#include "terminatedlgbase.h"
#include "terminatedlg.h"

TerminateDialog::TerminateDialog(TQWidget* parent, const char* name)
	: KDialogBase(parent, name, true, i18n("Terminate Session"), Ok|Cancel, Ok, true)
{
	m_base = new TerminateDlgBase(this);

	setMainWidget(m_base);

	connect(m_base->m_btnImmediate, SIGNAL(clicked()), this, SLOT(processLockouts()));
	connect(m_base->m_btnDelayed, SIGNAL(clicked()), this, SLOT(processLockouts()));

	m_base->m_btnDelayed->setChecked(false);
	m_base->m_btnImmediate->setChecked(true);
	processLockouts();
}

void TerminateDialog::processLockouts() {
	if (m_base->m_btnDelayed->isChecked()) {
		m_base->terminateMinutes->setEnabled(true);
	}
	if (m_base->m_btnImmediate->isChecked()) {
		m_base->terminateMinutes->setEnabled(false);
	}
}

void TerminateDialog::setWarningLabelText(TQString text) {
	m_base->m_warningLabel->setText(text);
}

void TerminateDialog::enableDelayedTermination(bool enabled) {
	if (enabled) {
		m_base->m_btnImmediate->setEnabled(true);
		m_base->m_btnDelayed->setEnabled(true);
	}
	else {
		m_base->m_btnImmediate->setChecked(true);
		m_base->m_btnImmediate->setEnabled(true);
		m_base->m_btnDelayed->setEnabled(false);
	}
}

bool TerminateDialog::delayed() {
	return m_base->m_btnDelayed->isChecked();
}

int TerminateDialog::minutes() {
	if (m_base->m_btnDelayed->isChecked()) {
		return m_base->terminateMinutes->value();
	}
	else {
		return -1;
	}
}

void TerminateDialog::slotOk() {
	accept();
}

#include "terminatedlg.moc"
