#
# spec file for package tdexsldbg (version R14)
#
# Copyright (c) 2014 Trinity Desktop Environment
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.
#
# Please submit bugfixes or comments via http://www.trinitydesktop.org/
#

# TDE variables
%define tde_epoch 2
%if "%{?tde_version}" == ""
%define tde_version 14.1.5
%endif
%define tde_pkg tdexsldbg
%define tde_prefix /opt/trinity
%define tde_bindir %{tde_prefix}/bin
%define tde_confdir %{_sysconfdir}/trinity
%define tde_datadir %{tde_prefix}/share
%define tde_docdir %{tde_datadir}/doc
%define tde_includedir %{tde_prefix}/include
%define tde_libdir %{tde_prefix}/%{_lib}
%define tde_mandir %{tde_datadir}/man
%define tde_tdeappdir %{tde_datadir}/applications/tde
%define tde_tdedocdir %{tde_docdir}/tde
%define tde_tdeincludedir %{tde_includedir}/tde
%define tde_tdelibdir %{tde_libdir}/trinity


Name:		trinity-%{tde_pkg}
Epoch:		%{tde_epoch}
Version:	%{tde_version}
Release:	%{?tde_version}_%{?!preversion:1}%{?preversion:0_%{preversion}}%{?dist}
Summary:	Graphical XSLT debugger for TDE
Group:		Applications/Multimedia
URL:		http://www.trinitydesktop.org/

%if 0%{?suse_version}
License:	GPL-2.0+
%else
License:	GPLv2+
%endif

#Vendor:		Trinity Desktop
#Packager:	Francois Andriot <francois.andriot@free.fr>

Prefix:		%{tde_prefix}
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Source0:		%{name}-%{tde_version}%{?preversion:~%{preversion}}.tar.gz

BuildRequires:	trinity-tdelibs-devel >= %{tde_version}
BuildRequires:	trinity-tdebase-devel >= %{tde_version}
BuildRequires:	desktop-file-utils

BuildRequires:	trinity-tde-cmake >= %{tde_version}
BuildRequires:	gcc-c++
BuildRequires:	pkgconfig
BuildRequires:	libtool

# SUSE desktop files utility
%if 0%{?suse_version}
BuildRequires:	update-desktop-files
%endif

%if 0%{?opensuse_bs} && 0%{?suse_version}
# for xdg-menu script
BuildRequires:	brp-check-trinity
%endif

Obsoletes:		trinity-kxsldbg < %{?epoch:%{epoch}:}%{version}-%{release}
Provides:		trinity-kxsldbg = %{?epoch:%{epoch}:}%{version}-%{release}

%description
KXSLDbg is a debugger for XSLT scripts. It includes a graphical user
interface as well as a text-based debugger. KXSLDbg can be run as a
standalone application or as an embedded TDE part.

XSLT is an XML language for defining transformations of XML files from
XML to some other arbitrary format, such as XML, HTML, plain text, etc.,
using standard XSLT stylesheets.

This package is part of TDE, as a component of the TDE web development module.
See the 'tde-trinity' and 'tdewebdev-trinity' packages for more information.

%if 0%{?suse_version} && 0%{?opensuse_bs} == 0
%debug_package
%endif

%prep
%setup -q -n %{name}-%{tde_version}%{?preversion:~%{preversion}}


%build
if ! rpm -E %%cmake|grep -e 'cd build\|cd ${CMAKE_BUILD_DIR:-build}'; then
  %__mkdir_p build
  cd build
fi

%cmake \
  -DCMAKE_BUILD_TYPE="RelWithDebInfo" \
  -DCMAKE_C_FLAGS="${RPM_OPT_FLAGS}" \
  -DCMAKE_CXX_FLAGS="${RPM_OPT_FLAGS} -DFORCE_DEBUGGER" \
  -DCMAKE_SKIP_RPATH=OFF \
  -DCMAKE_SKIP_INSTALL_RPATH=OFF \
  -DCMAKE_INSTALL_RPATH="%{tde_libdir}" \
  -DCMAKE_VERBOSE_MAKEFILE=ON \
  -DWITH_GCC_VISIBILITY=OFF \
  \
  -DCMAKE_INSTALL_PREFIX=%{tde_prefix} \
  -DSHARE_INSTALL_PREFIX=%{tde_datadir} \
  -DDATA_INSTALL_DIR=%{tde_datadir}/apps \
  -DLIB_INSTALL_DIR=%{tde_libdir} \
  \
  -DBUILD_ALL=ON \
  -DWITH_ALL_OPTIONS=ON \
  ..

%__make %{?_smp_mflags} || %__make


%install
export PATH="%{tde_bindir}:${PATH}"
%__rm -rf %{buildroot}
%__make install DESTDIR=%{buildroot} -C build

%find_lang kxsldbg

%files -f kxsldbg.lang
%defattr(-,root,root,-)
%{tde_bindir}/kxsldbg
%{tde_bindir}/xsldbg
%{tde_tdelibdir}/libkxsldbgpart.la
%{tde_tdelibdir}/libkxsldbgpart.so
%{tde_datadir}/applications/tde/kxsldbg.desktop
%{tde_datadir}/applnk/.hidden/xsldbg.desktop
%{tde_datadir}/apps/kxsldbg/kxsldbg_shell.rc
%{tde_datadir}/apps/kxsldbgpart/kxsldbg_part.rc
%lang(da) %{tde_tdedocdir}/HTML/da/kxsldbg/
%lang(da) %{tde_tdedocdir}/HTML/da/xsldbg/
%lang(de) %{tde_tdedocdir}/HTML/de/kxsldbg/
%lang(en) %{tde_tdedocdir}/HTML/en/kxsldbg/
%lang(en) %{tde_tdedocdir}/HTML/en/xsldbg/
%lang(es) %{tde_tdedocdir}/HTML/es/kxsldbg/
%lang(es) %{tde_tdedocdir}/HTML/es/xsldbg/
%lang(et) %{tde_tdedocdir}/HTML/et/kxsldbg/
%lang(et) %{tde_tdedocdir}/HTML/et/xsldbg/
%lang(fr) %{tde_tdedocdir}/HTML/fr/kxsldbg/
%lang(it) %{tde_tdedocdir}/HTML/it/kxsldbg/
%lang(it) %{tde_tdedocdir}/HTML/it/xsldbg/
%lang(nl) %{tde_tdedocdir}/HTML/nl/kxsldbg/
%lang(nl) %{tde_tdedocdir}/HTML/nl/xsldbg/
%lang(pt) %{tde_tdedocdir}/HTML/pt/kxsldbg/
%lang(pt) %{tde_tdedocdir}/HTML/pt/xsldbg/
%lang(pt_BR) %{tde_tdedocdir}/HTML/pt_BR/kxsldbg/
%lang(pt_BR) %{tde_tdedocdir}/HTML/pt_BR/xsldbg/
%lang(ru) %{tde_tdedocdir}/HTML/ru/kxsldbg/
%lang(ru) %{tde_tdedocdir}/HTML/ru/xsldbg/
%lang(sv) %{tde_tdedocdir}/HTML/sv/kxsldbg/
%lang(sv) %{tde_tdedocdir}/HTML/sv/xsldbg/
%{tde_datadir}/icons/hicolor/*/actions/*.png
%{tde_datadir}/icons/hicolor/*/apps/*.png
%{tde_datadir}/icons/locolor/*/apps/*.png
%{tde_mandir}/man1/kxsldbg.1*
%{tde_datadir}/services/kxsldbg_part.desktop


%clean
%__rm -rf %{buildroot}


%changelog
