# Copyright 1999-2020 Gentoo Authors
# Copyright 2020-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

DESCRIPTION="Micro Linux distro to boot from CD and play video files localized in CD root"
HOMEPAGE="https://movix.sourceforge.net"
SRC_URI="https://sourceforge.net/projects/movix/files/eMoviX/${PV%.*}/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 ~arm64 ppc ppc64 x86"

# Don't use Gentoo mirrors
RESTRICT="mirror"

RDEPEND="app-cdr/cdrtools"
DEPEND="dev-lang/perl
	app-alternatives/awk"

src_install() {
	emake -j1 DESTDIR="${D}" install
	dodoc AUTHORS ChangeLog README* TODO
	# Mplayer is no longer built with support for win32 codecs in Gentoo
	#dosym /usr/lib/win32 /usr/share/emovix/codecs
}
