/***************************************************************************
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef PROGRAMCATALOG_H
#define PROGRAMCATALOG_H

#include <kgenericfactory.h>

#include <tqptrlist.h>

#include <cachedcatalog.h>

class TQWidget;
class TQString;
class KBookmarkManager;
class KBookmarkGroup;
class BookmarkCatalogSettings;

/**
@author Joe Ferris
*/
class BookmarkCatalog : public CachedCatalog
{
	TQ_OBJECT
  
public:
	BookmarkCatalog(TQObject *, const char *, const TQStringList&);
	virtual ~BookmarkCatalog();
	
	virtual void initialize();
	virtual void readSettings(TDEConfigBase *);
	virtual void writeSettings(TDEConfigBase *);
	virtual unsigned int minQueryLen() const;
	virtual TQWidget * configure();
	
public slots:
	void minQueryLenChanged(int);
	void toggleMozEnabled(bool);
	void toggleMozAuto(bool);
	void changeMozFile(const TQString &);
	TQString searchMozDir(TQString);
	
private:
	void cacheBookmarkList(KBookmarkGroup);
	void cacheMozillaBookmarks();
	TQString detectMozillaFile();
	
	KBookmarkManager *manager;
	int _minQueryLen;
	bool _mozEnabled;
	bool _mozAuto;
	TQString _mozFile;
	BookmarkCatalogSettings *settings;
};

#endif
