/* This file is part of the KDE project
   Copyright (C) 2003 Percy Leonhardt

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef OOIMPRESSEXPORT_H
#define OOIMPRESSEXPORT_H

#include "stylefactory.h"

#include <tqdom.h>

#include <KoFilter.h>

class TQDomElement;
class KoStore;

class OoImpressExport : public KoFilter
{
    TQ_OBJECT
  
public:
    OoImpressExport( KoFilter * parent, const char * name, const TQStringList & );
    virtual ~OoImpressExport();

    virtual KoFilter::ConversionStatus convert( const TQCString & from,
                                                const TQCString & to );

private:
    KoFilter::ConversionStatus openFile();

    void exportBody( TQDomDocument & doccontent, TQDomElement & body );
    void createDocumentMeta( TQDomDocument & docmeta );
    void createDocumentStyles( TQDomDocument & docstyles );
    void createDocumentContent( TQDomDocument & doccontent );
    void createDocumentManifest( TQDomDocument & docmanifest );
    void createDocumentSettings( TQDomDocument & docsetting );
    void appendTextbox( TQDomDocument & doc, TQDomElement & source, TQDomElement & target );
    void appendParagraph( TQDomDocument & doc, TQDomElement & source, TQDomElement & target );
    void appendText( TQDomDocument & doc, TQDomElement & source, TQDomElement & target );
    void appendLine( TQDomDocument & doc, TQDomElement & source, TQDomElement & target );
    void appendRectangle( TQDomDocument & doc, TQDomElement & source, TQDomElement & target );
    void appendEllipse( TQDomDocument & doc, TQDomElement & source, TQDomElement & target, bool pieObject = false );
    void set2DGeometry( TQDomElement & source, TQDomElement & target, bool pieObject = false, bool multiPoint = false );
    void setLineGeometry( TQDomElement & source, TQDomElement & target );
    void appendPolyline( TQDomDocument & doc, TQDomElement & source, TQDomElement & target,  bool polygone = false);
    void appendPicture( TQDomDocument & doc, TQDomElement & source, TQDomElement & target );
    void createPictureList( TQDomNode &pictures );
    void appendNote( TQDomDocument & doc, TQDomElement & source, TQDomElement & target );
    void appendGroupObject( TQDomDocument & doc, TQDomElement & source, TQDomElement & target );
    TQString rotateValue( double val );
    TQString pictureKey( TQDomElement &element );
    void createHelpLine( TQDomNode &helpline );
    void createAttribute( TQDomNode &attributeValue );
    void appendObjects(TQDomDocument & doccontent, TQDomNode &objects, TQDomElement &drawPage);

    int m_currentPage;
    int m_objectIndex;
    float m_pageHeight;
    StyleFactory m_styleFactory;
    TQString m_masterPageStyle;
    TQDomElement m_styles;
    TQDomDocument m_maindoc;
    TQDomDocument m_documentinfo;
    TQMap<TQString, TQString> m_pictureLst;

    TQString m_helpLine;
    int m_activePage;
    double m_gridX, m_gridY;
    bool m_snapToGrid;

    //load from kpresenter file format
    TQMap<TQString, TQString> m_kpresenterPictureLst;
    int m_pictureIndex;
    KoStore *m_storeinp;
    KoStore *m_storeout;
};

#endif
