/***************************************************************************
*   Copyright (C) 2004-2009 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xmlstring.h>
#include <libxslt/transform.h>
#include <libxslt/xsltutils.h>

#include <tqfile.h>
#include <tqstring.h>

#include "xsltransform.h"

namespace BibTeX
{

    XSLTransform::XSLTransform( const TQString& xsltFilename )
    {
        m_xlstStylesheet = xsltParseStylesheetFile(( const xmlChar* ) xsltFilename.latin1() );
        if ( m_xlstStylesheet == NULL )
            tqDebug( "Could not load XSLT file '%s'.", xsltFilename.latin1() );
    }

    XSLTransform::~XSLTransform()
    {
        xsltFreeStylesheet( m_xlstStylesheet );
    }

    TQString XSLTransform::transform( const TQString& xmlText )
    {
        TQString result = TQString::null;
        TQCString xmlCText = xmlText.utf8();
        xmlDocPtr document = xmlParseMemory( xmlCText, xmlCText.length() );
        if ( document )
        {
            if ( m_xlstStylesheet )
            {
                xmlDocPtr resultDocument = xsltApplyStylesheet( m_xlstStylesheet, document, NULL );
                if ( resultDocument )
                {
                    // Save the result into the TQString
                    xmlChar * mem;
                    int size;
                    xmlDocDumpMemoryEnc( resultDocument, &mem, &size, "UTF-8" );
                    result = TQString::fromUtf8( TQCString(( char * )( mem ), size + 1 ) );
                    xmlFree( mem );

                    xmlFreeDoc( resultDocument );
                }
                else
                    tqDebug( "Applying XSLT stylesheet to XML document failed" );
            }
            else
                tqDebug( "XSLT stylesheet is not available or not valid" );

            xmlFreeDoc( document );
        }
        else
            tqDebug( "XML document is not available or not valid" );

        return result;
    }

}
