# Copyright 1999-2024 Gentoo Authors
# Copyright 2020-2024 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_TYPE="dependencies"
TRINITY_MODULE_NAME="akode"
inherit trinity-base-2 cmake

DESCRIPTION="Simple framework to decode the most common audio formats"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="|| ( GPL-2 GPL-3 )"
SLOT="0"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="+alsa ffmpeg jack +libsamplerate mp3 musepack oss pulseaudio xiph"

DEPEND="
	alsa? ( media-libs/alsa-lib )
	ffmpeg? ( >=media-video/ffmpeg-5.0 )
	jack? ( virtual/jack )
	libsamplerate? ( media-libs/libsamplerate )
	mp3? ( media-libs/libmad )
	pulseaudio? ( media-libs/libpulse )
	xiph? (
		media-libs/flac
		media-libs/libvorbis
		media-libs/speex
	)
"
RDEPEND="${DEPEND}"

pkg_pretend() {
	if ! use alsa || use jack || use oss || use pulseaudio
	then
		ewarn "You haven't selected any audio sinc plugins to build."
		ewarn "Avaliable are: alsa, jack, oss, pulseaudio."
		ewarn "akode won't be able to playback any sound"
		ewarn
	fi

	if ! use ffmpeg || use musepack || use mp3 || use xiph
	then
		ewarn "You haven't selected any decoder plugins to build."
		ewarn "Avaliable are: ffmpeg, mp3, musepack, xiph (flac speex vorbis)"
		ewarn "akode will support only raw wav files"
		ewarn
	fi
}

src_configure() {
	local mycmakeargs=(
		-DWITH_SUN_SINK=OFF # solaris stuff
		-DWITH_LIBLTDL=OFF  # doesn't provide any additional functinality
		-DWITH_ALSA_SINK=$(usex alsa)
		-DWITH_OSS_SINK=$(usex oss)
		-DWITH_PULSE_SINK=$(usex pulseaudio)
		-DWITH_JACK_SINK=$(usex jack)
		-DWITH_FFMPEG_DECODER=$(usex ffmpeg)
		-DWITH_MPC_DECODER=$(usex musepack)
		-DWITH_MPEG_DECODER=$(usex mp3)
		-DWITH_XIPH_DECODER=$(usex xiph)
		-DWITH_SRC_RESAMPLER=$(usex libsamplerate)
	)

	cmake_src_configure
}
