/***************************************************************************
                          tlpeditors.h  -  description
                             -------------------
    begin                : gio apr 1 2004
    copyright            : (C) 2003 by gulmini luciano
    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TLPEDITORS_H
#define TLPEDITORS_H

#include "minieditor.h"
#include "propertysetter.h"

class KPushButton;
class TQLineEdit;
class TQLabel;
/**
  *@author gulmini luciano
  */


class TLPEditor : public miniEditor { //editor with a line text and a button calling a dialog
  TQ_OBJECT
  

  protected:
    TQLineEdit *m_le;
    TQLabel *m_label;
    KPushButton *m_pb;

  public:
    TLPEditor(TQWidget *parent, const char* name=0);
    virtual ~TLPEditor();
    virtual void setButtonIcon(TQString);
    void setToolTip(TQString);
    void setLabelText(TQString);
    void setWhatsThis(TQString);
    TQLineEdit* lineEdit() const { return m_le; }
    KPushButton* button() const { return m_pb; }
    virtual void setInitialValue(const TQString& s)=0;
    virtual void connectToPropertySetter(propertySetter* p)=0;

  signals:
    void valueChanged(const TQString&);
};

class fontEditor : public TLPEditor{
  TQ_OBJECT
  
  private:
    TQString m_initialValue;
    
  public:
    fontEditor(TQWidget *parent, const char* name=0);
    virtual void setInitialValue(const TQString& s) { m_initialValue = s; }
    virtual void connectToPropertySetter(propertySetter* p);

  public slots:
    void openFontChooser();
};

class URIEditor : public TLPEditor {
  TQ_OBJECT
  
  public:
    enum mode{ Multi, Single };
    enum URIResourceType{ audio, image, mousePointer };

  private:
    mode m_Mode;
    URIResourceType m_resourceType;

  public:
    URIEditor(TQWidget *parent, const char* name=0);
    void setMode(const mode& m);
    void setResourceType(const  URIResourceType& r) { m_resourceType = r ; }
    virtual void setInitialValue(const TQString& /*s*/){}
    virtual void connectToPropertySetter(propertySetter* p);

  public slots:
    void selectedURI(const TQString&);
    void selectedURIs(const TQStringList&);
    void openFileDialog();
};


#endif
