/* This file is part of the KDE project
   Copyright (C) 2002-2003 Norbert Andres <nandres@web.de>
             (C) 2002-2003 Philipp Mueller <philipp.mueller@gmx.de>
             (C) 2002 Laurent Montel <montel@kde.org>
             (C) 2002 John Dailey <dailey@vt.edu>
             (C) 2002 Ariya Hidayat <ariya@kde.org>
             (C) 2002 Werner Trobin <trobin@kde.org>
             (C) 2002 Harri Porten <porten@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __kspread_dlg_goalseek__
#define __kspread_dlg_goalseek__

#include <kdialog.h>
#include <tqpoint.h>
#include <tqrect.h>

class TQFrame;
class TQGridLayout;
class TQHBoxLayout;
class TQLabel;
class TQLineEdit;
class TQPushButton;
class TQVBoxLayout;

namespace KSpread
{
class Cell;
class Point;
class Sheet;
class View;

class GoalSeekDialog : public KDialog
{
  TQ_OBJECT
  

 public:
   GoalSeekDialog( View * parent, TQPoint const & marker, const char * name = 0,
                      bool modal = FALSE, WFlags fl = 0 );
   ~GoalSeekDialog();

  /**
   * Find out which widget got focus.
   */
  bool eventFilter( TQObject* obj, TQEvent* ev );

 public slots:
  void buttonOkClicked();
  void buttonCancelClicked();
  void slotSelectionChanged();

 protected:
  virtual void closeEvent ( TQCloseEvent * );

  TQGridLayout * GoalSeekDialogLayout;
  TQGridLayout * m_startFrameLayout;
  TQGridLayout * m_resultFrameLayout;

 private:
  View * m_pView;
  Cell * m_sourceCell;
  Cell * m_targetCell;
  double        m_result;
  int           m_maxIter;
  bool          m_restored;
  double        m_oldSource;

  TQString       m_oldText;
  TQString       m_sheetName;

  TQFrame      * m_startFrame;
  TQLineEdit   * m_targetValueEdit;
  TQLineEdit   * m_targetEdit;
  TQLineEdit   * m_sourceEdit;
  TQPushButton * m_buttonOk;
  TQPushButton * m_buttonCancel;
  TQFrame      * m_resultFrame;
  TQLabel      * m_newValueDesc;
  TQLabel      * m_currentValueLabel;
  TQLabel      * m_newValue;
  TQLabel      * m_currentValue;
  TQLabel      * m_resultText;

  /**
   * Tells which of the lineedits has the logical focus currently.
   * It may happen that a lineedit does not have tqt focus but
   * logical focus but not the other way round.
   */
  TQLineEdit   * m_focus;

  TQPoint        m_anchor;
  TQPoint        m_marker;
  TQRect         m_selection;

  void startCalc(double _start, double _goal);
  void chooseCleanup();
};

} // namespace KSpread

#endif
