/* This file is part of the KDE project
   Copyright (C) 2002 Ulrich Kuettler <ulrich.kuettler@mailbox.tu-dresden.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqstringlist.h>
#include <tqtextedit.h>
#include <tqtooltip.h>
#include <tqvariant.h>
#include <tqwhatsthis.h>

#include <tdeapplication.h>
#include <tdemessagebox.h>
#include <tdelocale.h>
#include <kstdguiitem.h>
#include <kpushbutton.h>

#include "formulastring.h"
#include "kformula_view.h"


FormulaString::FormulaString( KFormulaPartView* parent, const char* name, bool modal, WFlags fl )
    : TQDialog( parent, name, modal, fl ), view( parent )
{
    if ( !name )
	setName( "FormulaString" );
    resize( 511, 282 );
    setCaption( i18n( "Formula String" ) );
    setSizeGripEnabled( TRUE );
    TQVBoxLayout* FormulaStringLayout = new TQVBoxLayout( this, 11, 6, "FormulaStringLayout");

    textWidget = new TQTextEdit( this, "textWidget" );
    FormulaStringLayout->addWidget( textWidget );

    TQHBoxLayout* Layout2 = new TQHBoxLayout( 0, 0, 6, "Layout2");
    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Expanding, TQSizePolicy::Minimum );
    Layout2->addItem( spacer );

    position = new TQLabel( this, "position" );
    position->setText( trUtf8( "1:1" ) );
    Layout2->addWidget( position );
    FormulaStringLayout->addLayout( Layout2 );

    TQHBoxLayout* Layout1 = new TQHBoxLayout( 0, 0, 6, "Layout1");

    buttonHelp = new KPushButton( KStdGuiItem::help(), this, "buttonHelp" );
    buttonHelp->setAccel( 4144 );
    buttonHelp->setAutoDefault( TRUE );
    Layout1->addWidget( buttonHelp );
    spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Expanding, TQSizePolicy::Minimum );
    Layout1->addItem( spacer );

    buttonOk = new KPushButton( KStdGuiItem::ok(), this, "buttonOk" );
    buttonOk->setAccel( 0 );
    buttonOk->setAutoDefault( TRUE );
    buttonOk->setDefault( TRUE );
    Layout1->addWidget( buttonOk );

    buttonCancel = new KPushButton( KStdGuiItem::cancel(), this, "buttonCancel" );
    buttonCancel->setAccel( 0 );
    buttonCancel->setAutoDefault( TRUE );
    Layout1->addWidget( buttonCancel );
    FormulaStringLayout->addLayout( Layout1 );

    // signals and slots connections
    connect( buttonOk, TQ_SIGNAL( clicked() ), this, TQ_SLOT( accept() ) );
    connect( buttonCancel, TQ_SIGNAL( clicked() ), this, TQ_SLOT( reject() ) );
    connect( buttonHelp, TQ_SIGNAL(clicked() ), this, TQ_SLOT( helpButtonClicked() ) );
    connect( textWidget, TQ_SIGNAL( cursorPositionChanged( int, int ) ),
             this, TQ_SLOT( cursorPositionChanged( int, int ) ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
FormulaString::~FormulaString()
{
    // no need to delete child widgets, TQt does it all for us
}

void FormulaString::accept()
{
    TQStringList errorList = view->readFormulaString( textWidget->text() );
    if ( errorList.count() == 0 ) {
        TQDialog::accept();
    }
    else {
        KMessageBox::sorry( this, errorList.join( "\n" ), i18n( "Parser Error" ) );
    }
}

void FormulaString::helpButtonClicked()
{
  kapp->invokeHelp( "formula-strings", "kformula" );
}

void FormulaString::cursorPositionChanged( int para, int pos )
{
    position->setText( TQString( "%1:%2" ).arg( para+1 ).arg( pos+1 ) );
}

#include "formulastring.moc"
