// (c) 2004 Max Howell (max.howell@methylblue.com)
// See COPYING file for licensing information

#ifndef CODEINEMAINWINDOW_H
#define CODEINEMAINWINDOW_H

#include "../codeine.h"
#include <tdemainwindow.h>

class KURL;
class TQLabel;
class TQPopupMenu;
class TQSlider;
class VolumeAction;


namespace Codeine
{
   class MainWindow : public TDEMainWindow
   {
   TQ_OBJECT

      MainWindow();
     ~MainWindow();

      friend int ::main( int, char** );

      enum { SubtitleChannelsMenuItemId = 2000, AudioChannelsMenuItemId, AspectRatioMenuItemId };

   public slots:
      void play();
      void playMedia( bool show_welcome_dialog = false );

      void configure();
      void streamInformation();
      void captureFrame();

   private slots:
      void engineMessage( const TQString& );
      void engineStateChanged( Engine::State );
      void init();
      void showTime( int = -1 );
      void fullScreenToggled( bool );
      void setAudioChannels(const TQStringList&) const;
      void setSubtitleChannels(const TQStringList&) const;

   private:
      void setupActions();

      bool load( const KURL& );
      bool open( const KURL& );

      TQPopupMenu *menu(const TQString&);

      virtual void timerEvent( TQTimerEvent* );
      virtual void dragEnterEvent( TQDragEnterEvent* );
      virtual void dropEvent( TQDropEvent* );
      virtual void keyPressEvent( TQKeyEvent* );

      virtual void saveProperties( TDEConfig* );
      virtual void readProperties( TDEConfig* );

      virtual bool queryExit();

      TQSlider *m_positionSlider;
      TQLabel  *m_timeLabel;
      TQLabel  *m_titleLabel;
      TQWidget *m_analyzer;
      VolumeAction *m_volumeAction;

      //undefined
      MainWindow( const MainWindow& );
      MainWindow &operator=( const MainWindow& );
   };
}

#endif
