/***************************************************************************
    smb4tdeconfigdialog  -  The configuration dialog of Smb4K
                             -------------------
    begin                : Sa Apr 14 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4TDECONFIGDIALOG_H
#define SMB4TDECONFIGDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <tdeconfigdialog.h>
#include <klibloader.h>
#include <tdeaboutdata.h>
#include <kinstance.h>

// forward declarations
class Smb4KSettings;

/**
 * This is the (new) configuration dialog of Smb4K.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4TDEConfigDialog : public TDEConfigDialog
{
  TQ_OBJECT
  

  public:
    /**
     * The constructor.
     *
     * @param settings      The Smb4KSettings object that needs to be passed
     *                      so that the settings can be managed.
     *
     * @param parent        The parent widget
     *
     * @param name          The name of this dialog
     */
    Smb4TDEConfigDialog( Smb4KSettings *settings, TQWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor
     */
    ~Smb4TDEConfigDialog();

  protected:
    /**
     * Reimplemented from TQWidget to do last things before the
     * configuration dialog is shown.
     *
     * @param e             The show event object
     */
    void showEvent( TQShowEvent *e );

  protected slots:
    /**
     * Reimplemented from TDEConfigDialog. This slot does application
     * specific stuff first and then executes TDEConfigDialog::slotApply().
     */
    void slotApply();

    /**
     * Reimplemented from TDEConfigDialog. This slot does application
     * specific stuff first and then executes TDEConfigDialog::slotOk().
     */
    void slotOk();

    /**
     *Reimplemented from TDEConfigDialog. This slot does application
     * specific stuff first and then executes TDEConfigDialog::slotCancel().
     */
    void slotCancel();

    /**
     * The custom Samba settings changed. Decide if we have to
     * enable the 'Apply' button or not.
     */
    void slotCustomSambaSettingsChanged();

    /**
     * The 'Remove Entries' button in the 'Super User' page has been
     * clicked. Initialize the removal of Smb4K's configuration entries
     * from the configuration file of the currently chosen program.
     */
    void slotRemoveSuperUserEntries();

    /**
     * This slot is activated if the Smb4KFileIO::failed() signal is
     * received. It deselects all check boxes in the "Super User" page.
     */
    void slotReceivedFileIOFailed();

    /**
     * This slot is activated if the Smb4KFileIO::finished() signal is
     * received. It closes the dialog by invoking TDEConfigDialog::slotOk().
     */
    void slotReceivedFileIOFinished();

  private:
    /**
     * Load the custom Samba options
     */
    void loadCustomSambaOptions();

    /**
     * Save the custom Samba options
     */
    void saveCustomSambaOptions();

    /**
     * Load the authentication data
     */
    void loadAuthenticationData();

    /**
     * Save the authentication data
     */
    void saveAuthenticationData();

    /**
     * Write super user configuration entries to configuration file.
     *
     * @returns TRUE if something needs to be written.
     */
    bool writeSuperUserEntries();

    /**
     * Remove super user configuration entries from the configuration file.
     */
    void removeSuperUserEntries();

    /**
     * Checks that mandatorily needed input is provided for settings that
     * need it. This function will report all missing input to the user
     * via a message box.
     *
     * @returns TRUE if the check passed and FALSE if it failed.
     */
    bool checkSettings();
};


class TDEInstance;
class TDEAboutData;


class Smb4TDEConfigDialogFactory : KLibFactory
{
  TQ_OBJECT
  

  public:
    /**
     * The constructor.
     */
    Smb4TDEConfigDialogFactory();

    /**
     * The destructor.
     */
    virtual ~Smb4TDEConfigDialogFactory();

    /**
     * The instance
     */
    static TDEInstance *instance();

  protected:
    TQObject *createObject( TQObject *parent = 0, const char *name = 0,
                           const char *classname = "TQObject",
                           const TQStringList &args = TQStringList() );

  private:
    /**
     * The factory's instance
     */
    static TDEInstance *m_instance;

    /**
     * The factory's TDEAboutData object
     */
    static TDEAboutData *m_about;
};

#endif
