/*
    kopetechatwindow.h - Chat Window

    Copyright (c) 2002      by Olivier Goffart        <ogoffart @ kde.org>
    Copyright (c) 2004      by Martijn Klingens       <klingens@kde.org>

    Kopete    (c) 2002-2004 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KOPETECHATWINDOW_H
#define KOPETECHATWINDOW_H

#include <tdeparts/mainwindow.h>
#include <tqmovie.h>
#include "kopetecontact.h"
#include "tdeversion.h"

class TDEAction;
class TDEToggleAction;
class TDEActionMenu;
class KTempFile;
class TQPixmap;
class TQTabWidget;
class KSqueezedTextLabel;
class KPushButton;
class TQVBox;
class TQVBoxLayout;
class TQFrame;
class KTabWidget;
class TQLabel;
class KopeteEmoticonAction;
class KopeteView;
class TDESelectAction;
class ChatView;

namespace Kopete
{
class Message;
class ChatSession;
class Contact;
class Protocol;
typedef TQPtrList<Contact>  ContactPtrList;
}

class KopeteChatWindow : public KParts::MainWindow
{
	TQ_OBJECT
  

	enum {NEW_WINDOW, GROUP_BY_ACCOUNT, GROUP_ALL, GROUP_BY_GROUP, GROUP_BY_METACONTACT};

public:
	/**
	 * Find the appropriate window for a ChatView of the given protocol to
	 * dock into. If no such window exists, create one.
	 * @param protocol The protocol we are creating a view for
	 * @return A KopeteChatWindow suitable for docking a ChatView into. Guaranteed
	 *  to be a valid pointer.
	 */
	static KopeteChatWindow *window( Kopete::ChatSession *manager );
	~KopeteChatWindow();

	/**
	 * Attach an unattached chatview to this window
	 * @param chat The chat view to attach
	 */
	void attachChatView( ChatView *chat );

	/**
	 * Detach a chat view from this window
	 * @param chat The chat view to detach
	 */
	void detachChatView( ChatView *chat );

	/**
	 * Returns the number of chat views attached to this window
	 */
	int chatViewCount() { return chatViewList.count(); }

	/**
	 * Returns the chatview in the currently active tab, or the only chat view
	 * if chatViewCount() == 1
	 */
	ChatView *activeView();

	void updateMembersActions();
	void setStatus( const TQString & );

	/**
	 * Reimplemented from TDEMainWindow - asks each ChatView in the window if it is ok to close the window
	 * @return true if no ChatView objects to closing.
	 */
	virtual bool queryClose();
	virtual bool queryExit();

	KTempFile *backgroundFile;
	TQPtrList<ChatView> chatViewList;

private:
	// All KopeteChatWindows are created by the window function
	KopeteChatWindow( TQWidget *parent = 0, const char* name = "KopeteChatWindow" );

	/**
	 * The window list has changed:
	 * For each chat window, update it's Move Tab to Window action
	 */
	static void windowListChanged();

	void initActions(void);
	void saveOptions(void);
	void readOptions(void);
	void checkDetachEnable();
	void createTabBar();
	void deleteTabBar();
	void addTab( ChatView* );
	void setPrimaryChatView( ChatView* );
	const TQString fileContents( const TQString &file ) const;

	ChatView *m_activeView;
	ChatView *m_popupView;
	bool m_alwaysShowTabs;
	bool m_showFormatToolbar;
	bool adjustingFormatToolbar;
	bool updateBg;
	KTabWidget *m_tabBar;
	KPushButton *m_button_send;
	KSqueezedTextLabel *m_status_text;
	TQVBoxLayout *mainLayout;
	TQFrame *mainArea;
	TQLabel *anim;
	TQMovie animIcon;
	TQPixmap normalIcon;

	TDEAction *chatSend;
	TDEAction *historyUp;
	TDEAction *historyDown;
	TDEAction *nickComplete;

	TDEToggleAction *mStatusbarAction;

	TDEAction *tabLeft;
	TDEAction *tabRight;
	TDEAction *tabDetach;
	TDEAction* tabClose;

	TDEToggleAction* membersLeft;
	TDEToggleAction* membersRight;
	TDEToggleAction* toggleMembers;
	TDEToggleAction* toggleAutoSpellCheck;

	KopeteEmoticonAction *actionSmileyMenu;
	TDEActionMenu *actionActionMenu;
	TDEActionMenu *actionContactMenu;
	TDEActionMenu *actionDetachMenu;
	TDEActionMenu *actionTabPlacementMenu;
	TQString statusMsg;

signals:
	void closing( KopeteChatWindow* );

public slots:
	void slotSmileyActivated( const TQString & );
	void setActiveView( TQWidget *active );
	void updateBackground( const TQPixmap &pm );

private slots:
//	void slotPrepareSmileyMenu();
	void slotPrepareContactMenu();
	void slotPrepareDetachMenu();
	void slotPreparePlacementMenu();
	void slotUpdateSendEnabled();

	void slotCut();
	void slotCopy();
	void slotPaste();

	void slotSetBgColor();
	void slotSetFgColor();
	void slotSetFont();

	void slotHistoryUp();
	void slotHistoryDown();
	void slotPageUp();
	void slotPageDown();

	void slotSendMessage();
	void slotChatSave();
	void slotChatPrint();

	void slotPreviousTab();
	void slotNextTab();
	void slotDetachChat( int newWindowIndex = -1 );
	void slotPlaceTabs( int tabPlacement );

	void slotViewMenuBar();
	void slotToggleStatusBar();
	void slotToggleFormatToolbar( bool );

	void slotConfKeys();
	void slotConfToolbar();

	void slotViewMembersLeft();
	void slotViewMembersRight();
	void slotToggleViewMembers();
	void slotEnableUpdateBg() { updateBg = true; }

	void toggleAutoSpellChecking();
	void slotRTFEnabled( ChatView*, bool );
	void slotAutoSpellCheckEnabled( ChatView*, bool );

	void slotSetCaption( bool );
	void slotUpdateCaptionIcons( ChatView * );
	void slotChatClosed();
	void slotTabContextMenu( TQWidget*, const TQPoint & );
	void slotStopAnimation( ChatView* );
	void slotNickComplete();
	void slotCloseChat( TQWidget* );

	//slots for tabs from the chatview widget
	void updateChatState( ChatView* cv, int state );
	void updateChatTooltip( ChatView* cv );
	void updateChatLabel();

private:
	void updateSpellCheckAction();

protected:
	virtual void closeEvent( TQCloseEvent *e );
	virtual void windowActivationChange( bool );
};

#endif
