/***************************************************************************
 *   Copyright (C) 2004 by Tobias Glaesser                                 *
 *   tobi.web@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef FIND_DOCUMENTATIONOPTIONS_H
#define FIND_DOCUMENTATIONOPTIONS_H

#include "find_documentation_optionsbase.h"

class TQCheckListItem;
class TDEConfig;

class FindDocumentationOptions : public FindDocumentationOptionsBase
{
TQ_OBJECT
  
public:
    FindDocumentationOptions(TQWidget* parent = 0, const char* name = 0, bool modal = FALSE);
    ~FindDocumentationOptions();
    /*$PUBLIC_FUNCTIONS$*/
    virtual bool isContents( TQCheckListItem * item );
    virtual bool isGoogle( TQCheckListItem * item );
    virtual bool isIndex( TQCheckListItem * item );
    virtual bool isInfo( TQCheckListItem * item );
    virtual bool isMan( TQCheckListItem * item );

public slots:
    /*$PUBLIC_SLOTS$*/
    virtual void sourceMoveDown();
    virtual void sourceMoveUp();
    virtual void writeOptions();
    virtual void readOptions();

protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/

private:
    TQCheckListItem *m_man_item;
    TQCheckListItem *m_info_item;
    TQCheckListItem *m_index_item;
    TQCheckListItem *m_google_item;
    TQCheckListItem *m_contents_item;
    
    TDEConfig* config;    
};

#endif

