/***************************************************************************
                          fileselector.h - File selection widget
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _HAVE_FILESELECTOR_H_
#define _HAVE_FILESELECTOR_H_

/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqobject.h>
#include <tqstringlist.h>
#include <tqstring.h>
#include <tqwidget.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <kommander_export.h>

class TQBoxLayout;
class KPushButton;
class KLineEdit;

class TQShowEvent;
class KOMMANDER_EXPORT FileSelector : public TQWidget, public KommanderWidget
{
  TQ_OBJECT
  

  TQ_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  TQ_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  TQ_PROPERTY(bool KommanderWidget READ isKommanderWidget)
  TQ_PROPERTY(bool showEditor READ showEditor WRITE setShowEditor)
  TQ_PROPERTY(TQString buttonCaption READ caption WRITE setCaption)
  TQ_PROPERTY(TQString selectionFilter READ selectionFilter WRITE setSelectionFilter)
  TQ_PROPERTY(TQString selectionCaption READ selectionCaption WRITE setSelectionCaption)
  TQ_PROPERTY(SelectionType selectionType READ selectionType WRITE setSelectionType)
  TQ_ENUMS(SelectionType)
  TQ_PROPERTY(bool selectionOpenMultiple READ selectionOpenMultiple WRITE setSelectionOpenMultiple)
  
public:
  FileSelector(TQWidget *a_parent, const char *a_name);
  ~FileSelector();

  virtual bool isKommanderWidget() const;
  virtual void setAssociatedText(const TQStringList&);
  virtual TQStringList associatedText() const;
  virtual TQString currentState() const;
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);

  enum SelectionType { Open, Save, Directory };
  SelectionType selectionType() const;
  void setSelectionType(SelectionType);
  bool selectionOpenMultiple() const;
  void setSelectionOpenMultiple(bool);
  TQString selectionFilter() const;
  void setSelectionFilter(const TQString&); 
  TQString selectionCaption() const;
  void setSelectionCaption(const TQString&);
  TQString caption() const;
  void setCaption(const TQString&);
  bool showEditor() const;
  void setShowEditor(bool);

  virtual TQString handleDCOP(int function, const TQStringList& args);
  virtual bool isFunctionSupported(int function);

public slots:
  virtual void setWidgetText(const TQString&);
  virtual void makeSelection();
  virtual void populate();

signals:
  void widgetOpened();
  void widgetTextChanged(const TQString&);
  void contextMenuRequested(int xpos, int ypos);
protected:
  void contextMenuEvent( TQContextMenuEvent * e );

  bool m_openMultiple;
  TQString m_caption;
  TQString m_filter;
  SelectionType m_selectionType;
  KLineEdit *m_lineEdit;
  KPushButton *m_selectButton;
  TQBoxLayout *m_boxLayout;
  void showEvent(TQShowEvent *e);
private:
};

#endif
