/*
    urlhandlermanager.h

    This file is part of KMail, the KDE mail client.
    Copyright (c) 2003 Marc Mutz <mutz@kde.org>

    KMail is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License, version 2, as
    published by the Free Software Foundation.

    KMail is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the TQt library by Trolltech AS, Norway (or with modified versions
    of TQt that use the same license as TQt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    TQt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#ifndef __KMAIL_URLHANDLERMANAGER_H__
#define __KMAIL_URLHANDLERMANAGER_H__

#include <tqvaluevector.h>

class KURL;

class TQString;
class TQPoint;
class KMReaderWin;

namespace KMail {

  class URLHandler;

  namespace Interface {
    class BodyPartURLHandler;
  }

  /**
   * @short Singleton to manage the list of URLHandlers
   * @author Marc Mutz <mutz@kde.org>
   */
  class URLHandlerManager {
    static URLHandlerManager * self;

    URLHandlerManager();
  public:
    ~URLHandlerManager();

    static URLHandlerManager * instance() {
      if ( !self )
	self = new URLHandlerManager();
      return self;
    }

    void registerHandler( const URLHandler * handler );
    void unregisterHandler( const URLHandler * handler );

    void registerHandler( const Interface::BodyPartURLHandler * handler );
    void unregisterHandler( const Interface::BodyPartURLHandler * handler );

    bool handleClick( const KURL & url, KMReaderWin * w=0 ) const;
    bool handleShiftClick( const KURL &url, KMReaderWin *window = 0 ) const;
    bool handleContextMenuRequest( const KURL & url, const TQPoint & p, KMReaderWin * w=0 ) const;
    bool willHandleDrag( const KURL &url, const TQString& imagePath, KMReaderWin *window = 0 ) const;
    bool handleDrag( const KURL &url, const TQString& imagePath, KMReaderWin *window = 0 ) const;
    TQString statusBarMessage( const KURL & url, KMReaderWin * w=0 ) const;

  private:
    typedef TQValueVector<const URLHandler*> HandlerList;
    HandlerList mHandlers;
    class BodyPartURLHandlerManager;
    BodyPartURLHandlerManager * mBodyPartURLHandlerManager;
  };

} // namespace KMail

#endif // __KMAIL_URLHANDLERMANAGER_H__

