/*

    Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    */

#include "midiportdlg.h"
#include <tdelocale.h>

#include <tdeapplication.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <kseparator.h>
#include <kbuttonbox.h>
#include <tqlineedit.h>
#include <tqbutton.h>
#include <tqpushbutton.h>
#include <kstdguiitem.h>

MidiPortDlg::MidiPortDlg(TQWidget *parent, const char *oldname, const char *title) :TQDialog(parent,title,TRUE)
{
	TQVBoxLayout *mainlayout = new TQVBoxLayout(this);

// caption label: title

	mainlayout->addSpacing(5);
	TQLabel *captionlabel = new TQLabel(this);
	TQFont labelfont(captionlabel->font());
	labelfont.setPointSize(labelfont.pointSize()*3/2);
	captionlabel->setFont(labelfont);
	captionlabel->setText(i18n("OSS MIDI Port"));
	captionlabel->setAlignment(AlignCenter);
	//min_size(captionlabel);
	mainlayout->addWidget(captionlabel);

// hruler

	mainlayout->addSpacing(5);
	KSeparator *ruler2 = new KSeparator( KSeparator::HLine, this);
	mainlayout->addWidget(ruler2);
	mainlayout->addSpacing(5);

// editwidget

	edit = new TQLineEdit(this);
	edit->setText(oldname);
	//min_size(edit);

	mainlayout->addWidget(edit);

// hruler

	mainlayout->addSpacing(5);
	KSeparator *ruler = new KSeparator( KSeparator::HLine, this);
	mainlayout->addWidget(ruler);
	mainlayout->addSpacing(5);

// buttons

	TQHBoxLayout *buttonlayout = new TQHBoxLayout;
	mainlayout->addSpacing(5);
	mainlayout->addLayout(buttonlayout);
	mainlayout->addSpacing(5);

	buttonlayout->addSpacing(5);
	KButtonBox *bbox = new KButtonBox(this);

	TQPushButton *helpbutton = bbox->addButton(KStdGuiItem::help(), this, TQ_SLOT( help() ));
	bbox->addStretch(1);
	helpbutton->setAutoDefault( true );
	helpbutton->setDefault( true );

	TQPushButton *okbutton = bbox->addButton(KStdGuiItem::ok());
	connect( okbutton, TQ_SIGNAL( clicked() ), TQ_SLOT(accept() ) );
	okbutton->setAutoDefault( true );
	okbutton->setDefault( true );

	bbox->layout();

	buttonlayout->addWidget(bbox);
	buttonlayout->addSpacing(5);

	mainlayout->freeze();
}

const char *MidiPortDlg::device()
{
	return edit->text().ascii();
}

void MidiPortDlg::help()
{
	TDEApplication::kApplication()->invokeHelp("", "artsbuilder");
}

#include "midiportdlg.moc"
