/* This file is part of the Keep project
   Copyright (C) 2006 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */


#ifndef _LISTVIEWTOOLTIP_H_
#define _LISTVIEWTOOLTIP_H_

#include <tqtooltip.h>
#include <tqlistview.h>
#include <tqheader.h>

#include "backuplistviewitem.h"
#include "backup.h"

class ListViewToolTip : public TQToolTip
{
public:
	ListViewToolTip(TQListView* parent);

protected:
	void maybeTip( const TQPoint& p );

private:
	TQListView* listView;
};

inline ListViewToolTip::ListViewToolTip( TQListView* parent ): TQToolTip( parent->viewport() ), listView( parent ) {}

inline void ListViewToolTip::maybeTip( const TQPoint& p ) {
	if ( !listView )
		return;

	TQListViewItem* item = listView->itemAt( p );
	if ( !item )
		return;

	const TQRect itemRect = listView->itemRect( item );
	if ( !itemRect.isValid() )
		return;

	const int col = listView->header()->sectionAt( p.x() );
	if ( col == -1 )
		return;

	const TQRect headerRect = listView->header()->sectionRect( col );
	if ( !headerRect.isValid() )
		return;

	const TQRect cellRect( headerRect.left(), itemRect.top(),headerRect.width(), itemRect.height());

	BackupListViewItem* backupItem = static_cast<BackupListViewItem*>(item);

	TQString tipStr = backupItem->backup().htmlDesc();
/*
	if( col == 0 )
		tipStr = TQString( "Contents of this cell: <b>%1</b>" ).arg(item->text( 0 ) );
	else if( col == 1 )
		tipStr = TQString( "Contents of that cell: <em>%1</em>" ).arg(item->text( 1 ) );
	else
		tipStr = TQString( "Something else" );
*/
	tip( cellRect, tipStr );
}

#endif

