/***************************************************************************
 *   Copyright (C) 2004-2007 by Georgy Yunaev, gyunaev@ulduzsoft.com       *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef KDE_TQT_H
#define KDE_TQT_H

#include "config.h"

#if defined (USE_KDE)

	#define KQ_CLASSNAME(name)		K##name
	#define TDEQ_CLASSNAME(name)		TDE##name

	#include <tdeapplication.h>
	#include <tdemainwindow.h>
	#include <kstatusbar.h>
	#include <tdemenubar.h>
	#include <tdecmdlineargs.h>
	#include <tdelocale.h>
	#include <tdelistview.h>
	#include <tdefiledialog.h>
	#include <tdehtml_part.h>
	#include <ktabwidget.h>
	#include <tdepopupmenu.h>
	#include <tdemessagebox.h>
	#include <kprogress.h>
	#include <krun.h>

#else /* !USE_KDE */

	#define KQ_CLASSNAME(name)		TQ##name
	#define TDEQ_CLASSNAME(name)		TQ##name

	#include <tqapplication.h>
	#include <tqmainwindow.h>
	#include <tqstring.h>
	#include <tqstatusbar.h>
	#include <tqlistview.h>
	#include <tqfiledialog.h>
	#include <tqmenubar.h>
	#include <tqtabwidget.h>
	#include <tqmessagebox.h>
	#include <tqprogressdialog.h>

	#define i18n(A)		tr(A)

#endif /* USE_KDE */

/* common non-wrapped UI classes */
#include <tqsplitter.h>
#include <tqtoolbutton.h>
#include <tqheader.h>
#include <tqtextbrowser.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqcombobox.h>
#include <tqpushbutton.h>

/* common utility classes */
#include <tqwhatsthis.h>
#include <tqstring.h>
#include <tqtextedit.h>
#include <tqfile.h>
#include <tqdir.h>
#include <tqregexp.h>
#include <tqtimer.h>
#include <tqmap.h>
#include <tqeventloop.h>

class KQMainWindow : public TDEQ_CLASSNAME(MainWindow)
{
public:
	KQMainWindow ( TQWidget * parent, const char * name, WFlags f )
		: TDEQ_CLASSNAME(MainWindow) (parent, name, f) {};
};


class KQListView : public TDEQ_CLASSNAME(ListView)
{
public:
	KQListView(TQWidget *parent = 0, const char *name = 0, int f = 0);
};


class KTQProgressModalDialog : public KQ_CLASSNAME(ProgressDialog)
{
	public:
		KTQProgressModalDialog ( const TQString & captionText, const TQString & labelText, const TQString & cancelButtonText, int totalSteps, TQWidget * creator = 0 );
		
		// Seems like people have fun making classes incompatible
#if defined (USE_KDE)		
		void   setTotalSteps( int totalSteps ) { progressBar ()->setTotalSteps( totalSteps ); }
		void   setProgress( int progress ) { progressBar ()->setProgress( progress ); }
#else
		bool   wasCancelled() { return wasCanceled(); }
#endif
};

class KTQTabWidget : public KQ_CLASSNAME(TabWidget)
{
public:
	KTQTabWidget (TQWidget *parent = 0, const char *name = 0, int f = 0)
		: KQ_CLASSNAME(TabWidget) (parent, name, f) {};
};

class KTQPopupMenu : public TDEQ_CLASSNAME(PopupMenu)
{
public:
	KTQPopupMenu (TQWidget *parent = 0 )
		: TDEQ_CLASSNAME(PopupMenu) (parent) {};
};

#include <tqinputdialog.h>
#include <tqcheckbox.h>
#include <tqtextedit.h>
#include <tqradiobutton.h>
#include <tqspinbox.h>
#include <tqgroupbox.h>
#include <tqbuttongroup.h>
#include <tqtooltip.h>


class KCHMShowWaitCursor
{
	public:
		KCHMShowWaitCursor() { TQApplication::setOverrideCursor( TQCursor(TQt::WaitCursor) ); }
		~KCHMShowWaitCursor() { TQApplication::restoreOverrideCursor(); }
};

				 
#endif /* KDE_TQT_H */
