/*
 *
 *  Dialogs for tdebluez devices
 *
 *  Copyright (C) 2007  Tom Patzig <tpatzig@suse.de>
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of tdebluez.
 *
 *  kbluetooth is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kbluetooth is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef DEVICESETUPWIZARD_H
#define DEVICESETUPWIZARD_H

#include <tqtimer.h>

#include "devicesetupwizarddialog.h"

using namespace TDEBluetooth;

class DeviceSetupWizard: public DeviceSetupWizardDialog
{
    TQ_OBJECT

public:
    DeviceSetupWizard(ObjectManagerImpl *manager);
    ~DeviceSetupWizard();

    virtual void next();
    virtual void back();
    void setDevice(DeviceImpl *device);

private:
    void updateServiceList();
    void startPairing();

public slots: // Public slots
    /** the cancel button is connected to the reject() slot of TQDialog,
     *   so we have to reimplement this here to add a dialogbox to
     *   ask if we really want to quit the wizard.
     */
    void reject();
    /** maybe call a dialog that the wizard has finished.
     *   Calls applySettings() to save the current selection.
     */
    void accept();
    void closeDevice();

    /** We need this to use it in a TQTimer */
    void slotNext();

private slots:
    // from object manager
    void slotDeviceServicesResolvedChanged(const TQString &path, bool resolved);

    // local
    void slotPairingTimeOut();
    void slotConnectTimeOut();
    void slotConnectNextProfile();

    // from device1Proxy
    void slotAsyncErrorResponseDetected(int asyncCallId, const TQT_DBusError error);
    void slotConnectAsyncReply(int asyncCallId);
//    void slotDisconnectAsyncReply(int asyncCallId);
    void slotConnectProfileAsyncReply(int asyncCallId);
//    void slotDisconnectProfileAsyncReply(int asyncCallId);
    void slotPairAsyncReply(int asyncCallId);
    void slotCancelPairingAsyncReply(int asyncCallId);
    void slotCancelPairing();
    void slotCancelConnecting();
    void slotAdvancePairingProgressBar();
    void slotAdvanceConnectProgressBar();

protected slots:
    void slotCopySrc2Dst();
    void slotCopyDst2Src();

protected:
    // Protected methods
    // the close button on the titlebar sets e->accept() which we don't want.
    virtual void closeEvent(TQCloseEvent*);
    bool askClose();

private:
    ObjectManagerImpl *manager;
//    AdapterImpl *adapter;
    DeviceImpl *device;
    TQString address;
    TQStringList uuids;

    TQWidget* pairpage;
    TQWidget* pairingpage;
    TQWidget* connectpage;
    TQWidget* connectingpage;
    TQWidget* donepage;
    TQTimer* pairingTimer;
    TQTimer* connectTimer;

//    TQMap<int, TQString> asyncCalls;

    TQStringList preferredProfiles;
    TDEConfig* m_config;
};

#endif
