/*
 *
 *  Obex Object Manager implementation of bluez5
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of libtdebluez.
 *
 *  libtdebluez is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  libtdebluez is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef OBEXOBJECTMANAGERIMPL_H_INCLUDED
#define OBEXOBJECTMANAGERIMPL_H_INCLUDED

#include <tqdbusconnection.h>
#include <tdelocale.h>

#include "interfaces/propertiesProxy.h"
#include "interfaces/objectmanagerProxy.h"
#include "interfaces/agentmanager1Proxy.h"
#include "interfaces/client1Proxy.h"
#include "interfaces/session1Proxy.h"
#include "interfaces/filetransfer1Proxy.h"

namespace TDEObex
{

#define DBUS_CONN_NAME "TDEBluezObex"

class KDE_EXPORT ObexObjectManagerImpl: public org::freedesktop::DBus::ObjectManagerProxy
{
    TQ_OBJECT

public:
    //    ObexObjectManagerImpl(){}
    ObexObjectManagerImpl(const TQString& service, const TQString& path, TQObject* parent = 0, const char* name = 0);

    virtual ~ObexObjectManagerImpl();

    // --- helper to get private members of the class --- //
    //! to get information if TDEBluez is connected to D-Bus
    bool isConnectedToDBUS();
    //! pointer to the D-Bus connection
    TQT_DBusConnection* getConnection();
    //! to close the connection to D-Bus
    bool close();

    //
    org::bluez::obex::AgentManager1Proxy* getAgentManager();
    org::bluez::obex::Client1Proxy* getClient();
    //	ConnectionList listConnections(const TQString&);

private:
    bool initDBUS();

    void slotInterfacesAdded(const TQT_DBusObjectPath& object, const TQT_DBusDataMap<
            TQString>& interfaces);

    void slotInterfacesRemoved(const TQT_DBusObjectPath& object, const TQStringList& interfaces);

private:
    //! TQt connection to D-Bus
    TQT_DBusConnection dBusConn;
    org::bluez::obex::AgentManager1Proxy* mAgentManager;
    org::bluez::obex::Client1Proxy* mClient;
    org::bluez::obex::Session1Proxy* mSession;
    org::bluez::obex::FileTransfer1Proxy* mFileTransfer;

private slots:
    bool reconnect();

};
// class ObexObjectManagerImpl

};
// namespace TDEObex

#endif //OBEXOBJECTMANAGERIMPL_H_INCLUDED

// End of File
