//
// C++ Interface: kmfnetzone
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFNETZONE_H
#define KMFNETZONE_H

#include "netfilterobject.h"

// TQt includes
#include <tqptrlist.h>
#include <tqguardedptr.h>
#include <tqstring.h>
#include <tquuid.h>
#include <tqobject.h>

// KDE includes
#include <kdemacros.h>

// Project includes
#include "ipaddress.h"

namespace KMF {
class KMFGenericDoc;
class KMFProtocol;
class KMFProtocolUsage;
class KMFError;
class KMFCheckInput;
class IPAddress;
class KMFNetHost;
class KMFTarget;
class KMFNetwork;

//############ KMFNetZone #############
class KDE_EXPORT KMFNetZone : public NetfilterObject {
	TQ_OBJECT
  
public:
	KMFNetZone( NetfilterObject *parent, const char* objectname, const TQString& name );

	virtual ~KMFNetZone();
	
	virtual int type();
	virtual void clear();
	
	IPAddress* address() const {
		return m_address;
	};

	int operator==( const KMFNetZone& );
	
	bool isSameZone( KMFNetZone* );
	
	IPAddress* mask() const {
		IPAddress *addr = new IPAddress();
		addr->setAddress( IPAddress::calcNetworkMaskFromLength( m_maskLen ).toString() );
		return addr;
	};
	
	int maskLength() const {
		return m_maskLen;
	}
	
	KMFGenericDoc* doc() const;
	KMFNetwork* network() const;
	
	KMFNetZone* zone() const;
	KMFNetZone* rootZone();

	int getZoneType() const {
		return m_zoneType;
	};

	const TQString& guiName() const {
		return m_guiName;
	};
	
	virtual const TQString& name();
	const TQString& generateName( const TQString& );
	

	void setGuiName( const TQString& );
	
	void setNetwork( KMFNetwork* );
	void setZone( const IPAddress& , int );
	void setParentZone( KMFNetZone* );
	bool isRootZone();
	
	void setMaskLength( int );
	
	

	const TQDomDocument& getDOMTree();
	virtual void loadXML(const TQDomDocument&, TQStringList& errors );
	virtual void loadXML( TQDomNode, TQStringList& errors );
	
	KMFNetZone* addZone( const TQString& , KMFError* );
	void delZone( KMFNetZone*, bool desructive = true );

	KMFProtocolUsage* addProtocolUsage( const TQUuid& uuid, const TQDomDocument& xml );
	
	void delProtocolUsage( KMFProtocolUsage*, bool desructive = true );

	KMFNetHost* addNetHost( const TQString& name, const TQDomDocument& xml );
	KMFTarget* addTarget( const TQString& name, const TQDomDocument& xml );

	KMFTarget* findTargetByName( const TQString& name, bool fromRoot = true );
	KMFNetHost* findNetHostByName( const TQString& name, bool fromRoot = true );
	KMFNetZone* findNetZoneByName( const TQString& name, bool fromRoot = true );
	
	void delHost( KMFTarget*, bool desructive = true );

	TQPtrList<KMFProtocolUsage>& protocols() const;
	TQPtrList<KMFNetZone>& zones() const;
	TQPtrList<KMFTarget>& hosts() const;

	KMFProtocolUsage* findProtocolUsageByProtocolUuid( const TQUuid& uuid ) const;
	
	bool protocolInherited( const TQUuid& uuid ) const;
	
	KMFTarget* placeHostInZone( KMFTarget* host );
	KMFNetZone* placeZoneInZone( KMFNetZone* zone );
	void refreshNetworkTree();
	
	bool readOnly() const {
		return m_readOnly;
	};
	void setReadOnly( bool );	
	
	TQString toString();
	
	enum { ROOT, NODE } Type;
	
	void getAllTargets( KMFNetZone* zone, TQPtrList<KMFTarget>* list );
	
protected slots:
	void slotOnProtocolUsageDeleted( TQObject* protocol );
	
private: // Methods
	KMFTarget* findTargetByName_internal( const TQString& name );
	KMFNetZone* findNetZoneByName_internal( const TQString& name );
	TQString zoneInfo();
	
	void getAllZones( KMFNetZone* zone, TQPtrList<KMFNetZone>* list );
	void getAllHosts( KMFNetZone* zone, TQPtrList<KMFTarget>* list );
	
	
	
	
private: // Data
	TQGuardedPtr<KMFGenericDoc> m_doc;
	TQGuardedPtr<KMFNetZone> m_zone;
	TQGuardedPtr<KMFNetwork> m_network;
	IPAddress* m_address;
	
	TQPtrList<KMFProtocolUsage> m_protocols;
	TQPtrList<KMFNetZone> m_zones;
	TQPtrList<KMFTarget> m_hosts;
	KMFError *m_err;
	int m_zoneType;
	int m_maskLen;
// 	bool m_deadEnd;
	TQString m_guiName;
	bool m_readOnly;	
};
}


#endif
