/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   Copyright (C) 2000 Trolltech AS.  All rights reserved.                *
*   info@trolltech.com                                                    *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Library General Public License as       *
*   published by the Free Software Foundation; either version 2 of the    *
*   License, or (at your option) any later version.                       *
*                                                                         *
***************************************************************************/

#ifndef INPUTMASK_H
#define INPUTMASK_H

#include <tqobject.h>

namespace Kugar
{

class InputMask : public TQObject
{
    TQ_OBJECT
  
public:
    InputMask( TQObject *parent = 0, const char *name = 0 );

    ~InputMask();

    TQString mask() const;
    void setMask( const TQString &mask );

    TQString formatText( const TQString &txt );

private:
    void parseInputMask( const TQString &maskFields );
    bool isValidInput( TQChar key, TQChar mask ) const;
    TQString maskString( uint pos, const TQString &str, bool clear = FALSE ) const;
    TQString clearString( uint pos, uint len ) const;
    TQString stripString( const TQString &str ) const;
    int findInMask( int pos, bool forward, bool findSeparator, TQChar searchChar = TQChar() ) const;

private:
    TQString m_text;
    int m_maxLength;
    TQChar m_blank;
    TQString m_mask;
    struct MaskInputData
    {
        enum Casemode { NoCaseMode, Upper, Lower };
        TQChar maskChar; // either the separator char or the inputmask
        bool separator;
        Casemode caseMode;
    };
    MaskInputData *m_maskData;
};

}

#endif
