/*
 *  kis_tool_select_brush.cpp - part of Chalk
 *
 *  Copyright (c) 2004 Boudewijn Rempt <boud@valdyas.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <tqevent.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqwidget.h>

#include <kdebug.h>
#include <tdeaction.h>
#include <kcommand.h>
#include <tdelocale.h>

#include "kis_brush.h"
#include "kis_layer.h"
#include "kis_paintop.h"
#include "kis_paintop_registry.h"
#include "kis_button_press_event.h"
#include "kis_button_release_event.h"
#include "kis_cmb_composite.h"
#include "kis_cursor.h"
#include "kis_doc.h"
#include "kis_move_event.h"
#include "kis_painter.h"
#include "kis_selection.h"
#include "kis_tool_select_eraser.h"
#include "kis_types.h"
#include "kis_view.h"
#include "kis_selection_options.h"

KisToolSelectEraser::KisToolSelectEraser()
        : super(i18n("SelectEraser"))
{
    setName("tool_select_eraser");
    setCursor(KisCursor::load("tool_eraser_selection_cursor.png", 5, 5));
    m_optWidget = 0;
    m_paintOnSelection = true;
}

KisToolSelectEraser::~KisToolSelectEraser()
{
}

void KisToolSelectEraser::activate()
{
    super::activate();

    if (!m_optWidget)
        return;

    m_optWidget->slotActivated();
}

void KisToolSelectEraser::initPaint(KisEvent */*e*/) 
{
    if (!m_currentImage || !m_currentImage->activeDevice()) return;

    m_mode = PAINT;
    m_dragDist = 0;

    // Create painter
    KisPaintDeviceSP dev = m_currentImage->activeDevice();
    
    if (dev == 0) return;
    
    if (m_painter)
        delete m_painter;
    if(! dev->hasSelection())
    {
        dev->selection()->clear();
        dev->emitSelectionChanged();
    }
    KisSelectionSP selection = dev->selection();

    m_target = selection;
    m_painter = new KisPainter(selection.data());
    TQ_CHECK_PTR(m_painter);
    m_painter->beginTransaction(i18n("Selection Eraser"));
    m_painter->setPaintColor(KisColor(TQt::white, selection->colorSpace()));
    m_painter->setBrush(m_subject->currentBrush());
    m_painter->setOpacity(OPACITY_OPAQUE);
    m_painter->setCompositeOp(COMPOSITE_ERASE);
    KisPaintOp * op = KisPaintOpRegistry::instance()->paintOp("eraser", 0, painter());
    painter()->setPaintOp(op); // And now the painter owns the op and will destroy it.

    // Set the cursor -- ideally. this should be a mask created from the brush,
    // now that X11 can handle colored cursors.
#if 0
    // Setting cursors has no effect until the tool is selected again; this
    // should be fixed.
    setCursor(KisCursor::eraserCursor());
#endif
}

void KisToolSelectEraser::endPaint() {
    super::endPaint();
    if (m_currentImage && m_currentImage->activeDevice())
        m_currentImage->activeDevice()->emitSelectionChanged();
}
void KisToolSelectEraser::setup(TDEActionCollection *collection)
{
    m_action = static_cast<TDERadioAction *>(collection->action(name()));

    if (m_action == 0) {
        m_action = new TDERadioAction(i18n("Selection &Eraser"),
                        "tool_eraser_selection", "Ctrl+Shift+E", this,
                        TQ_SLOT(activate()), collection,
                        name());
        TQ_CHECK_PTR(m_action);
        m_action->setToolTip(i18n("Erase parts of a selection"));
        m_action->setExclusiveGroup("tools");
        m_ownAction = true;
    }
}

TQWidget* KisToolSelectEraser::createOptionWidget(TQWidget* parent)
{
    Q_UNUSED(parent);
    // Commented out due to the fact that this doesn't actually work if you change the action
#if 0
    m_optWidget = new KisSelectionOptions(parent, m_subject);
    TQ_CHECK_PTR(m_optWidget);
    m_optWidget->setCaption(i18n("Selection Eraser"));

    TQVBoxLayout * l = dynamic_cast<TQVBoxLayout*>(m_optWidget->layout());
    l->addItem(new TQSpacerItem(1, 1, TQSizePolicy::Fixed, TQSizePolicy::Expanding));

    return m_optWidget;
#endif
    return 0;
}

TQWidget* KisToolSelectEraser::optionWidget()
{
    return m_optWidget;
}

#include "kis_tool_select_eraser.moc"

