/**
 * Copyright (C) 2002-2003 by Koos Vriezen <koos.vriezen@gmail.com>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef KMPLAYERVIEW_H
#define KMPLAYERVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <tqwidget.h>
#include <tqtextedit.h>

#include <kdockwidget.h>
#include <kurl.h>
#include <qxembed.h>
#include <tdemediaplayer/view.h>

#include "kmplayersource.h"

#define MOUSE_INVISIBLE_DELAY 2000

class TQWidgetStack;
class TQPixmap;
class TQPaintDevice;
class TQPainter;
class TQSlider;
class TQLabel;
class TDEActionCollection;
class TDEAction;
class TDEShortcut;
class KStatusBar;
class KFindDialog;

namespace KMPlayer {

class View;
class ViewArea;
class Viewer;
class ControlPanel;
class VolumeBar;
class Console;
class PlayListView;
class PlayListView;
class RootPlayListItem;

typedef KStatusBar StatusBar;

/*
 * The console GUI
 */
class TextEdit : public TQTextEdit {
public:
    TextEdit (TQWidget * parent, View * view);
protected:
    void contextMenuEvent (TQContextMenuEvent * e);
private:
    View * m_view;
};

/*
 * The infowindow GUI
 */
class InfoWindow : public TQTextEdit {
public:
    InfoWindow (TQWidget * parent, View * view);
    KDE_NO_EXPORT View * view () const { return m_view; }
protected:
    void contextMenuEvent (TQContextMenuEvent * e);
private:
    View * m_view;
};

/*
 * The view containing ViewArea and playlist
 */
class KMPLAYER_EXPORT View : public KMediaPlayer::View {
    TQ_OBJECT
  
public:
    enum ControlPanelMode {
        CP_Hide, CP_AutoHide, CP_Show, CP_Only /* no video widget */
    };
    enum StatusBarMode {
        SB_Hide, SB_Show, SB_Only /* no video widget */
    };
    enum WidgetType {
        WT_Video, WT_Console, WT_Picture, WT_Last
    };

    View (TQWidget *parent, const char *);
    ~View();

    void addText (const TQString &, bool eol=false);
    void init (TDEActionCollection * ac);
    void reset ();
    //void print(TQPrinter *pPrinter);

    TextEdit * console () const { return m_multiedit; }
    KDE_NO_EXPORT Viewer * viewer () const { return m_viewer; }
    KDE_NO_EXPORT ControlPanel * controlPanel () const {return m_control_panel;}
    KDE_NO_EXPORT StatusBar * statusBar () const {return m_status_bar;}
    KDE_NO_EXPORT PlayListView * playList () const { return m_playlist; }
    KDE_NO_EXPORT InfoWindow * infoPanel () const { return m_infopanel; }
    KDE_NO_EXPORT TQWidgetStack * widgetStack () const { return m_widgetstack; }
    KDE_NO_EXPORT KDockArea * docArea () const { return m_dockarea; }
    KDE_NO_EXPORT ViewArea * viewArea () const { return m_view_area; }
    KDE_NO_EXPORT bool keepSizeRatio () const { return m_keepsizeratio; }
    void setKeepSizeRatio (bool b);
    void showWidget (WidgetType w);
    void setControlPanelMode (ControlPanelMode m);
    void setStatusBarMode (StatusBarMode m);
    void setEraseColor (const TQColor &);
    KDE_NO_EXPORT ControlPanelMode controlPanelMode () const { return m_controlpanel_mode; }
    KDE_NO_EXPORT StatusBarMode statusBarMode () const { return m_statusbar_mode; }
    void delayedShowButtons (bool show);
    bool isFullScreen () const;
    int statusBarHeight () const;
    KDE_NO_EXPORT bool editMode () const { return m_edit_mode; }
    bool setPicture (const TQString & path);
    KDE_NO_EXPORT TQPixmap * image () const { return m_image; }
    void setNoInfoMessages (bool b) { m_no_info = b; }
    void setViewOnly ();
    void setInfoPanelOnly ();
    void setPlaylistOnly ();
    void setEditMode (RootPlayListItem *, bool enable=true);
    void dragEnterEvent (TQDragEnterEvent *);
    void dropEvent (TQDropEvent *);
    KDE_NO_EXPORT void emitPictureClicked () { emit pictureClicked (); }
    /* raise video widget, might (auto) hides panel */
    void videoStart ();
    void playingStart ();
    /* shows panel */
    void playingStop ();
public slots:
    void setVolume (int);
    void updateVolume ();
    void fullScreen ();
    void updateLayout ();
    void toggleShowPlaylist ();
    void toggleVideoConsoleWindow ();
    void setInfoMessage (const TQString & msg);
    void setStatusMessage (const TQString & msg);
signals:
    void urlDropped (const KURL::List & urls);
    void pictureClicked ();
    void fullScreenChanged ();
    void windowVideoConsoleToggled (int wt);
protected:
    void leaveEvent (TQEvent *) KDE_NO_EXPORT;
    void timerEvent (TQTimerEvent *) KDE_NO_EXPORT;
    bool x11Event (XEvent *) KDE_NO_EXPORT;
private:
    // widget for player's output
    Viewer * m_viewer;
    // console output
    TextEdit * m_multiedit;
    // widget stack contains m_viewer, m_multiedit and m_picturewidget
    TQWidgetStack * m_widgetstack;
    // widget that layouts m_widgetstack for ratio setting and m_control_panel
    ViewArea * m_view_area;
    // playlist widget
    PlayListView * m_playlist;
    // infopanel widget
    InfoWindow * m_infopanel;
    // all widget types
    TQWidget * m_widgettypes [WT_Last];
    KDockArea * m_dockarea;
    KDockWidget * m_dock_video;
    KDockWidget * m_dock_playlist;
    KDockWidget * m_dock_infopanel;
    TQString tmplog;
    TQPixmap * m_image;
    ControlPanel * m_control_panel;
    StatusBar * m_status_bar;
    TQSlider * m_volume_slider;
    const char * m_mixer_object;
    ControlPanelMode m_controlpanel_mode;
    ControlPanelMode m_old_controlpanel_mode;
    StatusBarMode m_statusbar_mode;
    int controlbar_timer;
    int infopanel_timer;
    bool m_keepsizeratio;
    bool m_playing;
    bool m_mixer_init;
    bool m_inVolumeUpdate;
    bool m_tmplog_needs_eol;
    bool m_revert_fullscreen;
    bool m_no_info;
    bool m_edit_mode;
};

/*
 * The video widget
 */
class KMPLAYER_EXPORT Viewer : public QXEmbed {
    TQ_OBJECT
  
public:
    Viewer(TQWidget *parent, View * view);
    ~Viewer();

    int heightForWidth (int w) const;

    void setAspect (float a);
    float aspect () { return m_aspect; }
    void sendKeyEvent (int key);
    void setBackgroundColor (const TQColor & c);
    void resetBackgroundColor ();
    void setCurrentBackgroundColor (const TQColor & c);
    KDE_NO_EXPORT View * view () const { return m_view; }
    void changeProtocol (QXEmbed::Protocol p);
public slots:
    void sendConfigureEvent ();
protected:
    void dragEnterEvent (TQDragEnterEvent *);
    void dropEvent (TQDropEvent *);
    void mouseMoveEvent (TQMouseEvent * e);
    void contextMenuEvent (TQContextMenuEvent * e);
    virtual void windowChanged( WId w );
private:
    WId m_plain_window;
    unsigned int m_bgcolor;
    float m_aspect;
    View * m_view;
};

} // namespace

#endif // KMPLAYERVIEW_H
