/***************************************************************************
    smb4k.h  -  The main class of Smb4K.
                             -------------------
    begin                : Sam M�  1 14:57:21 CET 2003
    copyright            : (C) 2003-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4K_H
#define SMB4K_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <tdeaction.h>
#include <tdeparts/dockmainwindow.h>

// Forward declarations
class Smb4KSystemTray;

/**
 * This is the application shell of Smb4K.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KApp : public KParts::DockMainWindow
{
  TQ_OBJECT
  

  public:
    /**
     * The constructor.
     *
     * @param parent        The parent of this widget
     *
     * @param name          The name of this widget
     */
    Smb4KApp( TQWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    ~Smb4KApp();

  protected:
    /**
     * Reimplemented from TDEMainWindow.
     */
    bool queryExit();

    /**
     * Reimplemented from TDEMainWindow.
     */
    bool queryClose();

    /**
     * Reimplemented from TQObject
     */
    void timerEvent( TQTimerEvent *e );

  protected slots:
    /**
     * Quit the application.
     */
    void slotQuit();

    /**
     * Replace the current shares view.
     */
    void slotChangeSharesView();

    /**
     * Open the configuration dialog. This slot is connected to the "Configure Smb4K..."
     * action.
     */
    void slotConfigDialog();

    /**
     * This slot is invoked when the config dialog is closed and the settings have
     * been changed. Emits the reloadSettings() signal and adjusts the system tray
     * widget to the new settings afterwards.
     */
    void slotSettingsChanged();

    /**
     * Open the bookmark editor. This slot is connected to the "Edit Bookmarks"
     * action.
     */
    void slotBookmarkEditor();

    /**
     * Show a message to the user what currently is done by the application. This
     * slot is connected to the Smb4KCore::runStateChanged() signal.
     */
    void slotRunStateChanged();

    /**
     * This slot is invoked when the bookmarks have been updated. It inserts the
     * bookmarks into the menu. Additionally, it enables the "Edit Bookmarks"
     * action if there are bookmarks and else disables it.
     */
    void slotSetupBookmarksMenu();

    /**
     * This slot is invoked when/if a bookmark is activated.
     */
    void slotBookmarkActivated();

    /**
     * This slot is activated when the list of mounted shares has been updated.
     * It is connected to the Smb4KMounter::updated() signal.
     */
    void slotShareListUpdated();

    /**
     * This slot is activated when an action is highlighted and lets m_action
     * point to it. No validity checks are performed.
     *
     * @param action        The action that has been highlighted
     */
    void slotActionHighlighted( TDEAction *action );

    /**
     * This slot sets the keyboard focus to the network browser and shows it
     * if it is not already shown.
     */
    void slotJumpToNetworkBrowser();

    /**
     * This slot sets the keyboard focus to the search dialog and shows it
     * if it is not already shown.
     */
    void slotJumpToSearchDialog();

    /**
     * This slot sets the keyboard focus to the shares view. Since it is the
     * main widget, this slot does not care about it being hidden.
     */
    void slotJumpToSharesView();

  private:
    /**
     * Set up actions.
     */
    void setupActions();

    /**
     * Set up the view.
     */
    void setupView();

    /**
     * Set up the status bar
     */
    void setupStatusBar();

    /**
     * Set up the system tray
     */
    void setupSystemTray();

    /**
     * Change the shares view.
     */
    void changeSharesView();

    /**
     * The shares view part
     */
    KParts::Part *m_shares_part;

    /**
     * The browser part
     */
    KParts::Part *m_browser_part;

    /**
     * The search dialog part
     */
    KParts::Part *m_search_part;

    /**
     * The system tray icon of this application
     */
    Smb4KSystemTray *m_system_tray;

    /**
     * Enumeration for the status bar
     */
    enum StatusBarItem{ Message = 0, Progress = 1, Version = 2 };

    /**
     * The currently highlighted TDEAction.
     */
    TDEAction *m_action;

    /**
     * This holds the config entry of the current shares
     * view. This is used to avoid unnecessary loading.
     */
    int m_current_shares_view;

    /**
     * The timer id
     */
    int m_timer_id;
};

#endif
