/***************************************************************************
 *                                                                         *
 *   Copyright (C) 2005, 2006 by Kevin Gilbert                             *
 *   kev.gilbert@cdu.edu.au                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 ***************************************************************************/
#ifndef _TIMINGWIDGET_H_
#define _TIMINGWIDGET_H_

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <ntqwidget.h>
#include "global.h"

//	forward class definitions
//	=========================

class TDEConfig;
class TQCheckBox;
class TQLineEdit;
class TQPushButton;
class TQRadioButton;

//	TimingWidget class definition
//	=============================

class TimingWidget : public TQWidget
{	TQ_OBJECT

	public:
		TimingWidget( TQWidget* parent, const char* name = NULL );

		void    finaliseInitialisation( );
		bool    getOptions( );
		void    readProfile( TDEConfig* config );
		void    saveProfile( TDEConfig* config );
		void    setInitialValues( );
		TQString simpleTiming( ) const;

		bool    hostTimeoutState( )       const { return m_hostTimeoutState;       }
		uint    hostTimeoutValue( )       const { return m_hostTimeoutValue;       }
		bool    initialRTTTimeoutState( ) const { return m_initialRTTTimeoutState; }
		uint    initialRTTTimeoutValue( ) const { return m_initialRTTTimeoutValue; }
		bool    maxHostGroupState( )      const { return m_maxHostGroupState;      }
		uint    maxHostGroupValue( )      const { return m_maxHostGroupValue;      }
		bool    maxParallelismState( )    const { return m_maxParallelismState;    }
		uint    maxParallelismValue( )    const { return m_maxParallelismValue;    }
		bool    maxRTTTimeoutState( )     const { return m_maxRTTTimeoutState;     }
		uint    maxRTTTimeoutValue( )     const { return m_maxRTTTimeoutValue;     }
		bool    maxScanDelayState( )      const { return m_maxScanDelayState;      }
		uint    maxScanDelayValue( )      const { return m_maxScanDelayValue;      }
		bool    minHostGroupState( )      const { return m_minHostGroupState;      }
		uint    minHostGroupValue( )      const { return m_minHostGroupValue;      }
		bool    minParallelismState( )    const { return m_minParallelismState;    }
		uint    minParallelismValue( )    const { return m_minParallelismValue;    }
		bool    minRTTTimeoutState( )     const { return m_minRTTTimeoutState;     }
		uint    minRTTTimeoutValue( )     const { return m_minRTTTimeoutValue;     }
		bool    scanDelayState( )         const { return m_scanDelayState;         }
		uint    scanDelayValue( )         const { return m_scanDelayValue;         }

	signals:
		void displayDocBook( const TQString& );
		void displayHelp( const TQString& );
		void displayUnknown( );
		void optionsDirty( );

	private slots:
		void slotAggressiveRadioClicked( );
		void slotDefaultRadioClicked( );
		void slotHostTimeoutButtonClicked( );
		void slotHostTimeoutCheckBoxClicked( );
		void slotInitialRTTTimeoutButtonClicked( );
		void slotInitialRTTTimeoutCheckBoxClicked( );
		void slotInsaneRadioClicked( );
		void slotMaxHostGroupButtonClicked( );
		void slotMaxHostGroupCheckBoxClicked( );
		void slotMaxParallelismButtonClicked( );
		void slotMaxParallelismCheckBoxClicked( );
		void slotMaxRTTTimeoutButtonClicked( );
		void slotMaxRTTTimeoutCheckBoxClicked( );
		void slotMaxScanDelayButtonClicked( );
		void slotMaxScanDelayCheckBoxClicked( );
		void slotMinHostGroupButtonClicked( );
		void slotMinHostGroupCheckBoxClicked( );
		void slotMinParallelismButtonClicked( );
		void slotMinParallelismCheckBoxClicked( );
		void slotMinRTTTimeoutButtonClicked( );
		void slotMinRTTTimeoutCheckBoxClicked( );
		void slotNormalRadioClicked( );
		void slotParanoidRadioClicked( );
		void slotPoliteRadioClicked( );
		void slotScanDelayButtonClicked( );
		void slotScanDelayCheckBoxClicked( );
		void slotSneakyRadioClicked( );
		void slotWhatsThisClicked( );

	private:
		void createLayout( );

		//	simple timing indices
		//	=====================
		
		enum Timing
		{	Default_Timing,
			Aggressive_T4_Timing,
			Insane_T5_Timing,
			Normal_T3_Timing,
			Paranoid_T0_Timing,
			Polite_T2_Timing,
			Sneaky_T1_Timing
		};

		TQRadioButton* m_aggressiveRadio;
		TQRadioButton* m_defaultRadio;
		TQPushButton*  m_hostTimeoutButton;
		TQCheckBox*    m_hostTimeoutCheckBox;
		TQLineEdit*    m_hostTimeoutLineEdit;
		bool          m_hostTimeoutState;
		uint          m_hostTimeoutValue;
		TQPushButton*  m_initialRTTTimeoutButton;
		TQCheckBox*    m_initialRTTTimeoutCheckBox;
		TQLineEdit*    m_initialRTTTimeoutLineEdit;
		bool          m_initialRTTTimeoutState;
		uint          m_initialRTTTimeoutValue;
		TQRadioButton* m_insaneRadio;
		TQPushButton*  m_maxHostGroupButton;
		TQCheckBox*    m_maxHostGroupCheckBox;
		TQLineEdit*    m_maxHostGroupLineEdit;
		bool          m_maxHostGroupState;
		uint          m_maxHostGroupValue;
		TQPushButton*  m_maxParallelismButton;
		TQCheckBox*    m_maxParallelismCheckBox;
		TQLineEdit*    m_maxParallelismLineEdit;
		bool          m_maxParallelismState;
		uint          m_maxParallelismValue;
		TQPushButton*  m_maxRTTTimeoutButton;
		TQCheckBox*    m_maxRTTTimeoutCheckBox;
		TQLineEdit*    m_maxRTTTimeoutLineEdit;
		bool          m_maxRTTTimeoutState;
		uint          m_maxRTTTimeoutValue;
		TQPushButton*  m_maxScanDelayButton;
		TQCheckBox*    m_maxScanDelayCheckBox;
		TQLineEdit*    m_maxScanDelayLineEdit;
		bool          m_maxScanDelayState;
		uint          m_maxScanDelayValue;
		TQPushButton*  m_minHostGroupButton;
		TQCheckBox*    m_minHostGroupCheckBox;
		TQLineEdit*    m_minHostGroupLineEdit;
		bool          m_minHostGroupState;
		uint          m_minHostGroupValue;
		TQPushButton*  m_minParallelismButton;
		TQCheckBox*    m_minParallelismCheckBox;
		TQLineEdit*    m_minParallelismLineEdit;
		bool          m_minParallelismState;
		uint          m_minParallelismValue;
		TQPushButton*  m_minRTTTimeoutButton;
		TQCheckBox*    m_minRTTTimeoutCheckBox;
		TQLineEdit*    m_minRTTTimeoutLineEdit;
		bool          m_minRTTTimeoutState;
		uint          m_minRTTTimeoutValue;
		TQRadioButton* m_normalRadio;
		TQRadioButton* m_paranoidRadio;
		TQRadioButton* m_politeRadio;
		TQPushButton*  m_scanDelayButton;
		TQCheckBox*    m_scanDelayCheckBox;
		TQLineEdit*    m_scanDelayLineEdit;
		bool          m_scanDelayState;
		uint          m_scanDelayValue;
		Timing        m_simpleTimingValue;
		TQRadioButton* m_sneakyRadio;
};

#endif	// _TIMINGWIDGET_H_
