/***************************************************************************
 *                                                                         *
 *   Copyright (C) 2005, 2006 by Kevin Gilbert                             *
 *   kev.gilbert@cdu.edu.au                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 ***************************************************************************/

#include <ntqdir.h>
#include <ntqlineedit.h>

#include <tdeaction.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kdebug.h>
#include <kedittoolbar.h>
#include <tdefiledialog.h>
#include <tdeglobalsettings.h>
#include <kinputdialog.h>
#include <kkeydialog.h>
#include <tdelocale.h>
#include <tdemainwindow.h>
#include <tdemessagebox.h>
#include <kstandarddirs.h>
#include <kstatusbar.h>
#include <kstdaction.h>

#include "htmlwidget.h"
#include "knmap.h"
#include "mainwidget.h"
#include "scanwidget.h"

//	constructor
//	===========

Knmap::Knmap( )
: TDEMainWindow( NULL, "knmap" ),
  m_mainWidget( new MainWidget( this, "main widget" ))
{	findNmap( );
	setCentralWidget( m_mainWidget );
	readSettings(  );
	createMenu( );
	setAutoSaveSettings( );

	connect( m_mainWidget,
			 TQ_SIGNAL( outputAvailable( const bool, const bool )),
			 TQ_SLOT( slotOutputAvailable( const bool, const bool)));

	connect( m_mainWidget,
			 TQ_SIGNAL( setManPageActionStuff( const bool )),
			 TQ_SLOT( slotSetManPageActionStuff( const bool )));

	connect( m_mainWidget,
			 TQ_SIGNAL( setCaption( const TQString& )),
			 TQ_SLOT( slotSetCaption( const TQString& )));

	connect( m_mainWidget,
			 TQ_SIGNAL( statusBarText( const TQString& )), statusBar( ),
			 TQ_SLOT( message( const TQString& )));

	connect( m_mainWidget,
			 TQ_SIGNAL( visibleScanWidgetChanged( ScanWidget* )),
			 TQ_SLOT( slotVisibleScanWidgetChanged( ScanWidget* )));
}

//	createMenu
//	==========

void Knmap::createMenu( )
{	KStdAction::configureToolbars( this, TQ_SLOT( slotConfigureToolbars( )), actionCollection( ));
	KStdAction::keyBindings( this, TQ_SLOT( slotConfigureShortcuts( )), actionCollection( ));
	KStdAction::quit( kapp, TQ_SLOT( quit( )), actionCollection( ));

	m_fileSaveAction = KStdAction::save( m_mainWidget,
										 TQ_SLOT( slotFileSave( )),
										 actionCollection( ));

	m_fileSaveAsAction = KStdAction::saveAs( m_mainWidget,
											 TQ_SLOT( slotFileSaveAs( )),
											 actionCollection( ));

	m_settingsManAction = new TDEAction( i18n( "&Use local man page" ),
										"localman.png",
										0,
										m_mainWidget,
										TQ_SLOT( slotSwitchManPages( )),
										actionCollection( ),
										"settings_local" );

	m_useTargetHostAction = new TDEToggleAction( i18n( "Use target host name" ),
											   NULL,
											   0,
											   m_mainWidget,
											   TQ_SLOT( slotUseTargetHost( )),
											   actionCollection( ),
											   "scan_use" );

	m_wrapTextAction = new TDEToggleAction( i18n( "Wrap text" ),
										  NULL,
										  0,
										  m_mainWidget,
										  TQ_SLOT( slotWrapText( )),
										  actionCollection( ),
										  "settings_wrap_text" );

	new TDEAction( i18n( "Close scan" ),
				 "scanclose",
				 CTRL+Key_W,
				 m_mainWidget,
				 TQ_SLOT( slotScanClose( )),
				 actionCollection( ),
				 "scan_close" );

	new TDEAction( i18n( "Copy profile..." ),
				 "profilecopy",
				 0,
				 m_mainWidget,
				 TQ_SLOT( slotProfileCopy( )),
				 actionCollection( ),
				 "profile_copy" );

	new TDEAction( i18n( "Delete profile..." ),
				 "profiledelete",
				 0,
				 m_mainWidget,
				 TQ_SLOT( slotProfileDelete( )),
				 actionCollection( ),
				 "profile_delete" );

	new TDEAction( i18n( "Display nmap man page" ),
				 "manpage",
				 0,
				 m_mainWidget,
				 TQ_SLOT( slotShowManPage( )),
				 actionCollection( ),
				 "help_man_page" );

	new TDEAction( i18n( "Duplicate scan" ),
				 "scanduplicate",
				 CTRL+Key_C,
				 m_mainWidget,
				 TQ_SLOT( slotScanDuplicate( )),
				 actionCollection( ),
				 "scan_duplicate" );

	new TDEAction( i18n( "Load profile..." ),
				 "profileload",
				 0,
				 m_mainWidget,
				 TQ_SLOT( slotProfileLoad( )),
				 actionCollection( ),
				 "profile_load" );

	new TDEAction( i18n( "man page stylesheet..." ),
				 "manstylesheet",
				 0,
				 m_mainWidget,
				 TQ_SLOT( slotSetStylesheet( )),
				 actionCollection( ),
				 "settings_stylesheet" );

	new TDEAction( i18n( "New scan..." ),
				 "scannew",
				 CTRL+Key_N,
				 m_mainWidget,
				 TQ_SLOT( slotScanNew( )),
				 actionCollection( ),
				 "scan_new" );

	new TDEAction( i18n( "Rename profile..." ),
				 "profilerename",
				 0,
				 m_mainWidget,
				 TQ_SLOT( slotProfileRename( )),
				 actionCollection( ),
				 "profile_rename" );

	new TDEAction( i18n( "Rename scan..." ),
				 "scanrename",
				 Key_F2,
				 m_mainWidget,
				 TQ_SLOT( slotScanRename( )),
				 actionCollection( ),
				 "scan_rename" );

	new TDEAction( i18n( "Save profile..." ),
				 "profilesave",
				 0,
				 m_mainWidget,
				 TQ_SLOT( slotProfileSave( )),
				 actionCollection( ),
				 "profile_save" );

	new TDEAction( i18n( "Save profile as..." ),
				 "profilesaveas",
				 0,
				 m_mainWidget,
				 TQ_SLOT( slotProfileSaveAs( )),
				 actionCollection( ),
				 "profile_save_as" );

	new TDEAction( i18n( "Zoom custom"  ),
				 "zoomcustom",
				 0,
				 m_mainWidget,
				 TQ_SLOT( slotZoomCustom( )),
				 actionCollection( ),
				 "settings_zoom_custom"  );

	new TDEAction( i18n( "Zoom in"  ),
				 "zoomin",
				 0,
				 m_mainWidget,
				 TQ_SLOT( slotZoomIn( )),
				 actionCollection( ),
				 "settings_zoom_in"  );

	new TDEAction( i18n( "Zoom out" ),
				 "zoomout",
				 0,
				 m_mainWidget,
				 TQ_SLOT( slotZoomOut( )),
				 actionCollection( ),
				 "settings_zoom_out" );

	m_fileSaveAction->setEnabled( false );
	m_fileSaveAsAction->setEnabled( false );
	m_wrapTextAction->setChecked( m_mainWidget->wrapText( ));

	createStandardStatusBarAction( );
	setStandardToolBarMenuEnabled( true );

	createGUI( );
}

//	findNmap
//	========

void Knmap::findNmap( )
{	TQString nmapPath = TDEStandardDirs::findExe( "nmap" );

	if( nmapPath.isEmpty( ))
	{	KMessageBox::error( this,
							i18n( "nmap is not installed on the computer - we cannot proceed without it. To download nmap go to \"http://www.insecure.org/nmap\"" ),
							i18n( "nmap not found" ));
		kapp->quit( );
	}
}

//	getDirPath
//	==========

bool Knmap::getDirPath( const TQString& caption, TQString& path )
{	TQString startDir = (path.isEmpty( )) ? TDEGlobalSettings::documentPath( ) : path;
	TQString tempPath = KFileDialog::getExistingDirectory( startDir, NULL, caption );

	if( tempPath.isEmpty( ))
		return false;

	path = tempPath;
	return true;
}

//	getDirPath
//	==========

void Knmap::getDirPath( const TQString& caption, TQString& path, TQLineEdit* lineEdit )
{	if( getDirPath( caption, path ))
		lineEdit->setText( path );
}

//	getFilePath
//	===========

bool Knmap::getFilePath( const TQString& caption, TQString& path, const bool save )
{	TQString filter   = "*.txt|Text files\n*.*|All files";
	TQString startDir = (path.isEmpty( )) ? TDEGlobalSettings::documentPath( ) : path;
	TQString tempPath = KFileDialog::getSaveFileName( startDir, filter, NULL, caption );

	if( tempPath.isEmpty( ))
		return false;

	if( save && TQFile::exists( tempPath ))
	{	if( KMessageBox::Yes != KMessageBox::questionYesNo( NULL, TQString( i18n( "File \"%1\" exists.\nOverwrite?" )).arg( tempPath ), i18n( "File exists" )))
			return false;
	}

	path = tempPath;
	return true;
}

//	getFilePath
//	===========

void Knmap::getFilePath( const TQString& caption, TQString& path, TQLineEdit* lineEdit, const bool save )
{	if( getFilePath( caption, path, save ))
		lineEdit->setText( path );
}

//	queryExit
//	=========

bool Knmap::queryExit( )
{	if( m_mainWidget->isDirty( ) && KMessageBox::Yes == KMessageBox::questionYesNo( this, i18n( "Some profiles has been updated - save them now?" ), i18n( "Profile data updated" )))
		m_mainWidget->saveAllDirtyProfiles( );

	saveSettings( );
	return true;
}

//	readSettings
//	============

void Knmap::readSettings( )
{	m_mainWidget->readSettings( );
}

//	saveSettings
//	============

void Knmap::saveSettings( )
{	m_mainWidget->saveSettings( );
}

//	slotConfigureShortcuts
//	======================

void Knmap::slotConfigureShortcuts( )
{	KKeyDialog::configure( actionCollection( ), this);
}

//	slotConfigureToolbars
//	=====================

void Knmap::slotConfigureToolbars( )
{	saveMainWindowSettings( TDEGlobal::config( ), autoSaveGroup( ));

	KEditToolbar dlg( actionCollection( ));
	connect( &dlg, TQ_SIGNAL( newToolbarConfig( )),this, TQ_SLOT( slotNewToolbarConfig( )));
	dlg.exec( );
}

//	slotNewToolbarConfig
//	====================

void Knmap::slotNewToolbarConfig( )
{
	createGUI( );

	applyMainWindowSettings( TDEGlobal::config( ), autoSaveGroup( ));
}

//	slotOutputAvailable
//	===================

void Knmap::slotOutputAvailable( const bool saveState, const bool saveAsState )
{	m_fileSaveAction->setEnabled( saveState );
	m_fileSaveAsAction->setEnabled( saveAsState );
}

//	slotSetCaption
//	==============

void Knmap::slotSetCaption( const TQString& caption )
{	setCaption( caption );
}

//	slotSetManPageActionStuff
//	=========================

void Knmap::slotSetManPageActionStuff( const bool useLocalManPage )
{	m_settingsManAction->setIcon( useLocalManPage ? "knmapman.png" : "localman.png" );
	m_settingsManAction->setText( useLocalManPage ? i18n( "&Use Knmap man page" ) : i18n( "&Use local man page" ));
}

//	slotVisibleScanWidgetChanged
//	============================

void Knmap::slotVisibleScanWidgetChanged( ScanWidget* scanWidget )
{	m_useTargetHostAction->setChecked( scanWidget->useTargetHost( ));
}

#include "knmap.moc"
