/***************************************************************************
                          tdepacmanview.h  -  description
                             -------------------
    begin                : Sam Jan 19 13:37:57 CET 2002
    copyright            : (C) 1998-2003 by Jörg Thönnissen
    email                : joe@dsite.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TDEPACMANVIEW_H
#define TDEPACMANVIEW_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

//include files for TQt
#include <tqwidget.h>
#include <tqregexp.h>

// application specific includes
#include "score.h"
#include "referee.h"
#include "status.h"
#include "painter.h"

/** The TDEpacmanView class provides the view widget for the TDEpacmanApp instance.
  * The View instance inherits TQWidget as a base class and represents the view object of a KTMainWindow.
  */
class TDEpacmanView : public TQWidget
{
    TQ_OBJECT
public:
    /** Constructor for the main view */
    TDEpacmanView ( TQWidget *parent = 0, const char *name = 0);
    /** Destructor for the main view */
    virtual ~TDEpacmanView();

    void setScheme(int scheme=-1, int mode=-1);
    Score *score;
    Referee *referee;
    Status *status;

protected:
    void confScheme();
    void confMisc(bool defGroup=TRUE);
    void resizeEvent( TQResizeEvent * );

private:
    Bitfont *bitfont;
    uchar bitfontFirstChar;
    uchar bitfontLastChar;

    TQString fontName;

    int scheme;
    int mode;
};

#endif // TDEPACMANVIEW_H
