#ifndef REFEREE_H               
#define REFEREE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <kapp.h>

#include <tqwidget.h>
#include <tqptrlist.h>
#include <tqstrlist.h>
#include <tqmemarray.h>
#include <tqbitarray.h>

#include "board.h"
#include "pacman.h"
#include "monster.h"
#include "fruit.h"
#include "energizer.h"
#include "bitfont.h"
#include "painter.h"

enum { Init, Introducing, Playing, Demonstration, Paused, Player, Ready, 
       Scoring, LevelDone, Dying, GameOver, HallOfFame };


class Referee : public TQWidget
{
    TQ_OBJECT
public:
    Referee (TQWidget *parent=0, const char *name=0, int scheme=-1, int mode=-1, Bitfont *font=0);

    void setSkill(int);
    void setRoom(int);

public slots:
    void setScheme(int scheme, int mode, Bitfont *font=0);

    void levelUp();
    void levelUpPlay();

    void pause();
    void ready();
    void intro();
    void introPlay();
    void hallOfFame();
    void demo();
    void play();
    void killed();
    void killedPlay();
    void eaten();
    void toggleHallOfFame();

    void setFocusOutPause(bool focusOutPause);
    void setFocusInContinue(bool focusInContinue);
    void initKeys();

    void repaintFigures();

private slots:
    void start();
    void stop();
    void stopEnergizer();

signals:
    void setScore(int, int);
    void setPoints(int);
    void setLevel(int);
    void setLifes(int);

    void focusedGamePause();
    void forcedGameHighscores();

protected:
    void timerEvent(TQTimerEvent *);
    void paintEvent(TQPaintEvent *);
    void keyPressEvent(TQKeyEvent *);

    void focusOutEvent(TQFocusEvent *);
    void focusInEvent(TQFocusEvent *);

    void fillArray(TQMemArray<int> &, TQString, int);
    void fillStrList(TQStrList &, TQString, int);
    void fillMapName();

    void confScheme();
    void confLevels(bool defGroup=TRUE);
    void confMisc(bool defGroup=TRUE);
    void confTiming(bool defGroup=TRUE);
    void confScoring(bool defGroup=TRUE);

private:
    TQBitArray gameState;
    int timerCount;
    int maxLevel;

    int scheme;
    int mode;

    TQString pixmapDirectory;
    TQString mapDirectory;
    TQStrList mapName;

    TQMemArray<int> speed;
    TQMemArray<int> monsterIQ;
    TQMemArray<int> fruitIQ;
    TQMemArray<int> fruitIndex;
    TQMemArray<int> pacmanTicks;
    TQMemArray<int> remTicks;
    TQMemArray<int> dangerousTicks;
    TQMemArray<int> harmlessTicks;
    TQMemArray<int> harmlessDurTicks;
    TQMemArray<int> harmlessWarnTicks;
    TQMemArray<int> arrestTicks;
    TQMemArray<int> arrestDurTicks;
    TQMemArray<int> fruitTicks;
    TQMemArray<int> fruitAppearsTicks;
    TQMemArray<int> fruitDurTicks;
    TQMemArray<int> fruitScoreDurTicks;

    int monsterScoreDurMS;
    int playerDurMS;
    int readyDurMS;
    int gameOverDurMS;
    int afterPauseMS;
    int dyingPreAnimationMS;
    int dyingAnimationMS;
    int dyingPostAnimationMS;
    int introAnimationMS;
    int introPostAnimationMS;
    int levelUpPreAnimationMS;
    int levelUpAnimationMS;
    int energizerAnimationMS;

    int pointScore;
    int energizerScore;
    TQMemArray<int> fruitScore;
    TQMemArray<int> monsterScore;
    TQMemArray<int> extraLifeScore;

    int extraLifeScoreIndex;
    int nextExtraLifeScore;

    int monstersEaten;
    int points;
    int lifes;
    int level;

    bool focusedPause;
    bool focusOutPause;
    bool focusInContinue;

    Board   *board;
    Painter *pix;
    Pacman  *pacman;
    Fruit   *fruit;

    TQPtrList<Monster> *monsters;
    TQPtrList<TQRect> *monsterRect;

    TQPtrList<Energizer> *energizers;
    TQPtrList<TQRect> *energizerRect;

    TQRect pacmanRect;
    TQRect fruitRect;

    void introMonster(int id);
    void introPaint(int t);

    void initMonsters();
    void initPacman();
    void initFruit(bool fullInitialization=TRUE);
    void initEnergizers();

    void setOnEnergizers();

    int  gameTimer;
    int  energizerTimer;
    void start(int);
    void init(bool);

    void score(int);

    uint UpKey;
    uint DownKey;
    uint RightKey;
    uint LeftKey;
};

#endif // REFEREE_H
