/***************************************************************************
                          setpageaudio.cpp  -  description
                             -------------------
    begin                : Thu Jan 10 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqregexp.h>
#include "setpageaudio.moc"

setPageAudio::setPageAudio(TQWidget *parent, resource *Rsrc ) : TQVBoxLayout(parent)
{
	Parent = parent;
	Resource = Rsrc;
	NewSounds = 0;
	changeTheme = FALSE;

	BUTTON_enableAudio = new TQCheckBox( i18n( "Enable Audio" ), parent );
	BUTTON_enableAudio->setChecked( Resource->OPTION_Audio );
	addWidget( BUTTON_enableAudio );
	connect(	BUTTON_enableAudio, TQ_SIGNAL( toggled(bool) ),
						this, TQ_SLOT( slot_enableAudio(bool) ) );

	GROUP_Theme = new TQGroupBox( 1,
																TQt::Vertical,
																i18n( "Audio Themes" ),
																parent );
	addWidget( GROUP_Theme );
	Current_Theme = new KComboBox ( GROUP_Theme );
	buildThemeList();
	connect(	Current_Theme, TQ_SIGNAL( activated(int) ),
						this, TQ_SLOT( slot_currentTheme(int) ) );

	BOX_Main = new TQHBox( parent );
	addWidget( BOX_Main );

	GROUP_Volume = new TQGroupBox( 3, TQt::Vertical, i18n( "Volume" ), BOX_Main );
	Vol_Max = new TQLabel( i18n( "Maximum" ), GROUP_Volume );
	Current_Volume = new TQSlider ( 0, 100, 10, Resource->Audio_Volume, 	TQt::Vertical, GROUP_Volume );
	connect(	Current_Volume, TQ_SIGNAL( valueChanged(int) ), this, TQ_SLOT( slot_currentVolume(int) ) );
	Current_Volume->setTickmarks( TQSlider::Right );
	Vol_Min = new TQLabel( i18n( "Minimum" ), GROUP_Volume );

	BOX_Options = new TQVBox( BOX_Main );
	BUTTON_AudioCurrentOnly = new TQCheckBox( i18n( "For Current Match Only" ), BOX_Options );
	BUTTON_AudioCurrentOnly->setChecked( Resource->OPTION_Audio_Current_Only );
	connect(	BUTTON_AudioCurrentOnly, TQ_SIGNAL( toggled(bool) ),
						this, TQ_SLOT( slot_AudioCurrentOnly(bool) ) );
}
setPageAudio::~setPageAudio()
{
}
///////////////////////////////////////
//
//	setPageAudio::slot_enableAudio
//
///////////////////////////////////////
void setPageAudio::slot_enableAudio( bool state )
{
	Resource->OPTION_Audio = state;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageAudio::slot_currentTheme
//
///////////////////////////////////////
void setPageAudio::slot_currentTheme( int Index )
{
	NewSounds = Index;
	changeTheme = TRUE;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageAudio::slot_currentVolume
//
///////////////////////////////////////
void setPageAudio::slot_currentVolume( int Level )
{
	Resource->Audio_Volume = Level;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageAudio::slot_AudioCurrentOnly
//
///////////////////////////////////////
void setPageAudio::slot_AudioCurrentOnly( bool state )
{
	Resource->OPTION_Audio_Current_Only = state;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageAudio::buildThemeList
//
///////////////////////////////////////
void setPageAudio::buildThemeList( void )
{
	TQString buffer;
	int tmp(0);

	Current_Theme->clear();
	Resource->readThemeDir();
	while(1)
	{
		buffer = Resource->getSounds( tmp );
		if( buffer.isEmpty() ) break;
		buffer.remove( 0, 2 );
		buffer.replace( TQRegExp("_"), " " );
		buffer.replace( TQRegExp(".tar"), "" );
		buffer.replace( TQRegExp(".gz"), "" );
		buffer.replace( TQRegExp(".bz2"), "" );
		Current_Theme->insertItem( buffer, tmp );
		if( Resource->getSounds() == Resource->getSounds( tmp ) )
		{
			Current_Theme->setCurrentItem( tmp );
			NewSounds = tmp;
		}
		tmp++;
	}
}
