/*
 * Port for usage with tqt-framework and development for tdesvn
 * (C) 2005-2007 by Rajko Albrecht
 * http://tdesvn.alwins-world.de
 */
/*
 * ====================================================================
 * Copyright (c) 2002-2005 The RapidSvn Group.  All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library (in the file LGPL.txt); if not,
 * write to the Free Software Foundation, Inc., 51 Franklin St,
 * Fifth Floor, Boston, MA  02110-1301  USA
 *
 * This software consists of voluntary contributions made by many
 * individuals.  For exact contribution history, see the revision
 * history and logs, available at http://rapidsvn.tigris.org/.
 * ====================================================================
 */

// subversion api
#include "svn_wc.h"

// svncpp
#include "exception.h"
#include "path.h"
#include "pool.h"
#include "wc.h"

namespace svn
{
  const char * Wc::ADM_DIR_NAME = SVN_WC_ADM_DIR_NAME;

  bool
  Wc::checkWc (const TQString& dir)
  {
    Pool pool;
    Path path (dir);
    int wc;

    svn_error_t * error = svn_wc_check_wc (
        path.path().TOUTF8(),
        &wc, pool);

    if ((error != NULL) || (wc == 0))
    {
      return false;
    }

    return true;
  }

  void
  Wc::ensureAdm (const TQString& dir, const TQString& uuid,
                 const TQString& url, const Revision & revision)
  {
    Pool pool;
    Path dirPath (dir);
    Path urlPath (url);

    svn_error_t * error =
      svn_wc_ensure_adm (
                         dirPath.path().TOUTF8(),    // path
                         uuid.TOUTF8(),                // UUID
                         urlPath.path().TOUTF8(),    // url
                         revision.revnum (),  // revision
                         pool);
    if(error != NULL)
      throw ClientException (error);
  }

  const svn_wc_entry_t *Wc::getEntry( const TQString &path )
  {
    Pool pool;
    Path itemPath(path);
    svn_error_t * error = 0;
    svn_wc_adm_access_t *adm_access;
    const svn_wc_entry_t *entry;
    error = svn_wc_adm_probe_open2(&adm_access,0,itemPath.path().TOUTF8(),FALSE,0,pool);
    if (error!=0) {
        throw ClientException(error);
    }
    error = svn_wc_entry(&entry,itemPath.path().TOUTF8(),adm_access,FALSE,pool);
    if (error!=0) {
        throw ClientException(error);
    }
    error = svn_wc_adm_close(adm_access);
    if (error!=0) {
        throw ClientException(error);
    }
    return entry;
  }

  TQString Wc::getUrl(const TQString&path)
  {
    TQString result = "";
    const svn_wc_entry_t *entry;
    entry = getEntry( path );
    result = entry?TQString::FROMUTF8(entry->url):"";

    return result;
  }

  TQString Wc::getRepos(const TQString&path)
  {
    TQString result = "";
    const svn_wc_entry_t *entry;
    entry = getEntry( path );
    result = entry ? TQString::FROMUTF8(entry->repos) : TQString::fromLatin1("");

    return result;
  }
}
