/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "synchronous.h"

#include "common/global/global.h"
#  include <tqwidget.h>

Synchronous::Synchronous(uint timeout)
{
  connect(&_timer, TQ_SIGNAL(timeout()), TQ_SLOT(done()));
  if (timeout) _timer.start(timeout, true);
}

// uplifted from tdelibs...
void tqt_enter_modal(TQWidget *widget);
void tqt_leave_modal(TQWidget *widget);

bool Synchronous::enterLoop()
{
  TQWidget *dummy = 0;
  if ( tqApp->type()!=TQApplication::Tty ) {
    dummy = new TQWidget(0, 0, WType_Dialog | WShowModal);
    dummy->setFocusPolicy(TQWidget::NoFocus);
    tqt_enter_modal(dummy);
  }
  TQApplication::eventLoop()->enterLoop();
  if ( tqApp->type()!=TQApplication::Tty ) {
    tqt_leave_modal(dummy);
    delete dummy;
  }
  return _timer.isActive();
}

void Synchronous::done()
{
  TQApplication::eventLoop()->exitLoop();
}
