/*
 * Copyright Johannes Sixt
 * This file is licensed under the GNU General Public License Version 2.
 * See the file COPYING in the toplevel directory of the source directory.
 */

#ifndef THREADLIST_H
#define THREADLIST_H

#include <tqlistview.h>
#include <tqpixmap.h>
#include <list>

class ThreadInfo;
class ThreadEntry;

class ThreadList : public TQListView
{
    TQ_OBJECT
public:
    ThreadList(TQWidget* parent, const char* name);
    ~ThreadList();

public slots:
    void updateThreads(const std::list<ThreadInfo>&);
    void slotCurrentChanged(TQListViewItem*);

signals:
    void setThread(int);

protected:
    ThreadEntry* threadById(int id);
    void makeNoFocusIcon();

    TQPixmap m_focusIcon;
    TQPixmap m_noFocusIcon;
};

#endif // THREADLIST_H
