// Copyright (C)  2002  Dominique Devriese <devriese@kde.org>

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.

#include "imageexporteroptions.h"
#include "imageexporteroptions.moc"

#include <tqcheckbox.h>
#include <tqsize.h>

#include <knuminput.h>

ImageExporterOptions::ImageExporterOptions( TQWidget* parent, const TQSize& s )
  : ImageExporterOptionsBase( parent, "imageexporteroptions" ), msize( s ),
    minternallysettingstuff( false )
{
  keepAspectRatio->setChecked( true );
  connect( WidthInput, TQ_SIGNAL( valueChanged( int ) ), this, TQ_SLOT( slotWidthChanged( int ) ) );
  connect( HeightInput, TQ_SIGNAL( valueChanged( int ) ), this, TQ_SLOT( slotHeightChanged( int ) ) );
}

ImageExporterOptions::~ImageExporterOptions()
{
}

void ImageExporterOptions::slotWidthChanged( int w )
{
  if ( ! minternallysettingstuff && keepAspectRatio->isOn() )
  {
    minternallysettingstuff = true;
    HeightInput->setValue( w * msize.height() / msize.width() );
    minternallysettingstuff = false;
  };
}

void ImageExporterOptions::slotHeightChanged( int h )
{
  if ( ! minternallysettingstuff && keepAspectRatio->isOn() )
  {
    minternallysettingstuff = true;
    WidthInput->setValue( h * msize.width() / msize.height() );
    minternallysettingstuff = false;
  };
}
