#!/usr/bin/env ruby
$VERBOSE = true; $:.unshift File.dirname($0)

require 'Qt'

class LCDRange < TQt::VBox

def initialize(grid)
   super
	lcd = TQt::LCDNumber.new(2, self, 'lcd')

    slider = TQt::Slider.new(TQt::VBox::Horizontal, self, 'slider')
    slider.setRange(0, 99)
    slider.setValue(0)

    lcd.connect(slider, TQ_SIGNAL('valueChanged(int)'), TQ_SLOT('display(int)'))
end

end

class MyWidget < TQt::VBox

def initialize()
   super
    quit = TQt::PushButton.new('Quit', self, 'quit')
    quit.setFont(TQt::Font.new('Times', 18, TQt::Font::Bold))
    
	connect(quit, TQ_SIGNAL('clicked()'), $qApp, TQ_SLOT('quit()'))
	grid = TQt::Grid.new( 4, self )
	
	for c in 0..3
		for r in 0..3
			LCDRange.new(grid)
		end
	end
end

end    

a = TQt::Application.new(ARGV)

w = MyWidget.new
a.setMainWidget(w)
w.show
a.exec
