# Copyright 2023 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_EXTRAGEAR_PACKAGING="yes"
TRINITY_HANDBOOK="never"

TRINITY_LANGS="ar bs ca ca@valencia cs da de el en_GB eo es et fi fr ga gl hr \
		hu is it ja kk km lt mai mr ms nb nds nl pa pl pt_BR pt ro ru \
		sk sl sr sv th tr ug uk vi zh_CN zh_TW"

TRINITY_MODULE_TYPE="applications/system"
inherit trinity-base-2

DESCRIPTION="TDE dialogs for PolicyKit"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="|| ( GPL-2 GPL-3 )"
SLOT="14"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~x86"
fi

DEPEND="~trinity-base/polkit-tqt-${PV}"
RDEPEND="${DEPEND}"

src_configure() {
	local mycmakeargs=(
		-DBUILD_TRANSLATIONS=ON
	)
	trinity-base-2_src_configure
}
