%{CPP_TEMPLATE}

#include <tqfileinfo.h>
#include <tqframe.h>

#include <tdeparts/part.h>
#include <kate/document.h>
#include <kate/view.h>
#include <tdelocale.h>
#include <klibloader.h>
#include <kurl.h>

#include "tdemdikonsole.h"

tdemdikonsole::tdemdikonsole(TQWidget *parent, const char *name) : TQVBox(parent, name)
{
	m_haskonsole = false;
	respawn();
}

tdemdikonsole::~tdemdikonsole()
{
}

void tdemdikonsole::respawn()
{
	KLibFactory *factory = KLibLoader::self()->factory("libkonsolepart");

	if (!factory) return;
	m_part = (KParts::ReadOnlyPart *) factory->create(this);

	if (!m_part) return;

	if (m_part->widget()->inherits("TQFrame"))
		((TQFrame*)m_part->widget())->setFrameStyle(TQFrame::Panel|TQFrame::Sunken);

	m_haskonsole=true;
	connect( m_part, TQT_SIGNAL(destroyed()), this, TQT_SLOT(slotDestroyed()) );

	m_part->widget()->show();
	show();
}

void tdemdikonsole::setDirectory(const TQString &dirname)
{
	if (m_haskonsole)
	{
		KURL url(dirname);
		if (m_part->url() != url)
			m_part->openURL(url);
	}
}

void tdemdikonsole::showEvent(TQShowEvent *ev)
{
	TQWidget::showEvent(ev);
	activate();
}

void tdemdikonsole::activate()
{
	if (m_haskonsole)
	{
		m_part->widget()->show();
		setFocusProxy(m_part->widget());
		m_part->widget()->setFocus();
	}
}

void tdemdikonsole::slotDestroyed()
{
	m_haskonsole=false;
	respawn();
}

#include "tdemdikonsole.moc"
