/***************************************************************************
 *   Copyright (C) 2003 by Alexander Dymo                                  *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHOOSESUBPROJECTDLG_H
#define CHOOSESUBPROJECTDLG_H

#include <tdelistview.h>

#include "choosesubprojectdlgbase.h"

class QMakeScopeItem;
class TrollProjectWidget;

class ChooseItem: public TDEListViewItem
{
public:
    ChooseItem(QMakeScopeItem *spitem, TQListViewItem *parent, TQString text);
    ChooseItem(QMakeScopeItem *spitem, TQListView *parent, TQString text);

    QMakeScopeItem *subproject();

private:
    QMakeScopeItem *m_spitem;
};

class ChooseSubprojectDlg : public ChooseSubprojectDlgBase
{
  TQ_OBJECT
  

public:
  ChooseSubprojectDlg(TrollProjectWidget *widget, TQWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~ChooseSubprojectDlg();
  /*$PUBLIC_FUNCTIONS$*/

  QMakeScopeItem *selectedSubproject();

public slots:
  /*$PUBLIC_SLOTS$*/

protected:
  /*$PROTECTED_FUNCTIONS$*/
  TrollProjectWidget *m_widget;

protected slots:
  /*$PROTECTED_SLOTS$*/
  virtual void accept();
  virtual void itemSelected(TQListViewItem *it);

private:
    void fillSubprojectsView(ChooseItem *item);

};

#endif
