/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2004-2007                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Thu Nov 20 2003
 */

// own header
#include "cppcodegenerationform.h"

// qt/kde includes
#include <tqlabel.h>
#include <tqregexp.h>
#include <tqlistview.h>
#include <tdefiledialog.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <kcombobox.h>
#include <tdemessagebox.h>


CPPCodeGenerationForm::CPPCodeGenerationForm( TQWidget *parent, const char *name )
        : CPPCodeGenerationFormBase (parent,name)
{
    init();

    GeneralOptionsListView->addColumn(tr2i18n("General Options"));
    pOptionPackageIsANamespace = new TQCheckListItem( GeneralOptionsListView,
                                 tr2i18n("Package is a namespace"),
                                 TQCheckListItem::CheckBox );
    pOptionVirtualDestructors = new TQCheckListItem( GeneralOptionsListView,
                                tr2i18n("Virtual destructors"),
                                TQCheckListItem::CheckBox );
    pOptionGenerateEmptyConstructors = new TQCheckListItem( GeneralOptionsListView,
                                       tr2i18n("Generate empty constructors"),
                                       TQCheckListItem::CheckBox );
    pOptionGenerateAccessorMethods = new TQCheckListItem( GeneralOptionsListView,
                                     tr2i18n("Generate accessor methods"),
                                     TQCheckListItem::CheckBox );
    pOptionOperationsAreInline = new TQCheckListItem( GeneralOptionsListView,
                                 tr2i18n("Operations are inline"),
                                 TQCheckListItem::CheckBox );
    pOptionAccessorsAreInline = new TQCheckListItem( GeneralOptionsListView,
                                tr2i18n("Accessors are inline"),
                                TQCheckListItem::CheckBox );

    pOptionAccessorsArePublic = new TQCheckListItem( GeneralOptionsListView,
                                tr2i18n("Accessors are public"),
                                TQCheckListItem::CheckBox );

    connect(GeneralOptionsListView,
            TQT_SIGNAL(clicked(TQListViewItem *)), this,
            TQT_SLOT(generalOptionsListViewClicked(TQListViewItem *))
           );

}

CPPCodeGenerationForm::~CPPCodeGenerationForm()
{
}

void CPPCodeGenerationForm::browseClicked()
{
    TQString button = sender()->name();
    TQString file = KFileDialog::getOpenFileName( TQString(), "*.h", this, "Get Header File");

    if(file.isEmpty())
        return;

    if(button=="m_browseStringButton") {
        // search for match in history list, if absent, then add it
        m_stringIncludeFileHistoryCombo->setCurrentItem(file, true);
    }
    else if(button=="m_browseListButton") {
        // search for match in history list, if absent, then add it
        m_listIncludeFileHistoryCombo->setCurrentItem(file, true);
    }
}

void CPPCodeGenerationForm::generalOptionsListViewClicked(TQListViewItem *pSender) {

    // operations are inline and accessors are operations :)
    if (pOptionOperationsAreInline->isOn() && pOptionGenerateAccessorMethods->isOn())
            pOptionAccessorsAreInline->setOn(true);

    if (pSender == pOptionPackageIsANamespace) {
#if 0
        KMessageBox::error(0, "CPPCodeGenerationForm::generalOptionsListViewClicked(): "
                           "sender=pOptionPackageIsANamespace");
#endif
        return;
    }
    if (pSender == pOptionVirtualDestructors) {
#if 0
        KMessageBox::error(0, "CPPCodeGenerationForm::generalOptionsListViewClicked(): "
                           "sender=pOptionVirtualDestructors");
#endif
        return;
    }
    if (pSender == pOptionGenerateEmptyConstructors) {
#if 0
        KMessageBox::error(0, "CPPCodeGenerationForm::generalOptionsListViewClicked(): "
                           "sender=pOptionVirtualDestructors");
#endif
        return;
    }
    if (pSender == pOptionGenerateAccessorMethods) {
        pOptionAccessorsAreInline->setEnabled(pOptionGenerateAccessorMethods->isOn());
        pOptionAccessorsArePublic->setEnabled(pOptionGenerateAccessorMethods->isOn());
        // reset the value if needed
        if (!pOptionGenerateAccessorMethods->isOn())
        {
            pOptionAccessorsAreInline->setOn(false);
            pOptionAccessorsArePublic->setOn(false);
        }
#if 0
        KMessageBox::error(0, "CPPCodeGenerationForm::generalOptionsListViewClicked(): "
                           "sender=pOptionGenerateAccessorMethods");
#endif
        return;
    }
    if (pSender == pOptionOperationsAreInline) {
#if 0
        KMessageBox::error(0, "CPPCodeGenerationForm::generalOptionsListViewClicked(): "
                           "sender=pOptionOperationsAreInline");
#endif
        return;
    }
    if (pSender == pOptionAccessorsAreInline) {
#if 0
        KMessageBox::error(0, "CPPCodeGenerationForm::generalOptionsListViewClicked(): "
                           "sender=pOptionAccessorsAreInline");
#endif
        return;
    }

#if 0
    KMessageBox::error(0, "CPPCodeGenerationForm::generalOptionsListViewClicked(): "
                       "unknown sender");
#endif
    return;
}

void CPPCodeGenerationForm::init() {
    pOptionPackageIsANamespace = NULL;
    pOptionVirtualDestructors = NULL;
    pOptionGenerateEmptyConstructors = NULL;
    pOptionGenerateAccessorMethods = NULL;
    pOptionOperationsAreInline = NULL;
    pOptionAccessorsAreInline = NULL;
}

/**
 *
 * set the display state of option "Package Is Namespace"
 *
 */
void CPPCodeGenerationForm::setPackageIsANamespace(bool bFlag) {
    pOptionPackageIsANamespace->setOn(bFlag);
}

/**
 *
 * set the display state of option "Virtual Destructors"
 *
 */
void CPPCodeGenerationForm::setVirtualDestructors(bool bFlag) {
    pOptionVirtualDestructors->setOn(bFlag);
}

/**
 *
 * set the display state of option "Generate Empty Constructors"
 *
 */
void CPPCodeGenerationForm::setGenerateEmptyConstructors(bool bFlag) {
    pOptionGenerateEmptyConstructors->setOn(bFlag);
}

/**
 *
 * set the display state of option "Generate Accessor Methods"
 *
 */
void CPPCodeGenerationForm::setGenerateAccessorMethods(bool bFlag) {
    pOptionGenerateAccessorMethods->setOn(bFlag);
    // initial settings
    pOptionAccessorsAreInline->setEnabled(pOptionGenerateAccessorMethods->isOn());
    pOptionAccessorsArePublic->setEnabled(pOptionGenerateAccessorMethods->isOn());
    // reset the value if needed
    if (!pOptionGenerateAccessorMethods->isOn())
    {
        pOptionAccessorsAreInline->setOn(false);
        pOptionAccessorsArePublic->setOn(false);
    }
}

/**
 *
 * set the display state of option "Operations Are Inline"
 *
 */
void CPPCodeGenerationForm::setOperationsAreInline(bool bFlag) {
    pOptionOperationsAreInline->setOn(bFlag);
}

/**
 *
 * set the display state of option "Accessors Are Inline"
 *
 */
void CPPCodeGenerationForm::setAccessorsAreInline(bool bFlag) {
    pOptionAccessorsAreInline->setOn(bFlag);
}

/**
 *
 * set the display state of option "Accessors Are Public"
 *
 */
void CPPCodeGenerationForm::setAccessorsArePublic(bool bFlag) {
    pOptionAccessorsArePublic->setOn(bFlag);
}

/**
 *
 * get the display state of option "Package Is Namespace"
 *
 */
bool CPPCodeGenerationForm::getPackageIsANamespace()
{
    return pOptionPackageIsANamespace->isOn();
}

/**
 *
 * get the display state of option "Virtual Destructors"
 *
 */
bool CPPCodeGenerationForm::getVirtualDestructors()
{
    return pOptionVirtualDestructors->isOn();
}

/**
 *
 * get the display state of option "Generate Empty Constructors"
 *
 */
bool CPPCodeGenerationForm::getGenerateEmptyConstructors()
{
    return pOptionGenerateEmptyConstructors->isOn();
}

/**
 *
 * get the display state of option "Generate Accessor Methods"
 *
 */
bool CPPCodeGenerationForm::getGenerateAccessorMethods()
{
    return pOptionGenerateAccessorMethods->isOn();
}

/**
 *
 * get the display state of option "Operations Are Inline"
 *
 */
bool CPPCodeGenerationForm::getOperationsAreInline()
{
    return pOptionOperationsAreInline->isOn();
}

/**
 *
 * get the display state of option "Accessors Are Inline"
 *
 */
bool CPPCodeGenerationForm::getAccessorsAreInline()
{
    return pOptionAccessorsAreInline->isOn();
}

/**
 *
 * get the display state of option "Accessors Are Public"
 *
 */
bool CPPCodeGenerationForm::getAccessorsArePublic()
{
    return pOptionAccessorsArePublic->isOn();
}


#include "cppcodegenerationform.moc"
