/***************************************************************************
                          texteffectpreferences.cpp  -  description
                             -------------------
    begin                : jeu nov 14 2002
    copyright            : (C) 2002 by Olivier Goffart
    email                : ogoffart @ kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqstring.h>
#include <tqlayout.h>
#include <tqcheckbox.h>
#include <tqpushbutton.h>

#include <tdelocale.h>
#include <kcolordialog.h>
#include <kgenericfactory.h>
#include <kautoconfig.h>
#include <kdebug.h>

#include <tdeversion.h>

#include "texteffectprefs.h"
#include "texteffectpreferences.h"
#include "texteffectconfig.h"

typedef KGenericFactory<TextEffectPreferences> TextEffectPreferencesFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kopete_texteffect, TextEffectPreferencesFactory( "kcm_kopete_texteffect" )  )

TextEffectPreferences::TextEffectPreferences(TQWidget *parent,
                                             const char* /*name*/,
                                             const TQStringList &args)
	: TDECModule(TextEffectPreferencesFactory::instance(), parent, args)
{
	( new TQVBoxLayout( this ) )->setAutoAdd( true );

	kdDebug( 14310 ) << "Creating preferences dialog" << endl;

	preferencesDialog = new TextEffectPrefs(this);

	kdDebug( 14310 ) << "Creating config object" << endl;

	config = new TextEffectConfig;

	kdDebug( 14310 ) << "Setting up connections" << endl;

	connect(preferencesDialog->mColorsAdd , TQT_SIGNAL(pressed()) ,
			this , TQT_SLOT(slotAddPressed()));

	connect(preferencesDialog->mColorsRemove , TQT_SIGNAL(pressed()) ,
			this , TQT_SLOT(slotRemovePressed()));

	connect(preferencesDialog->mColorsUp , TQT_SIGNAL(pressed()) ,
			this , TQT_SLOT(slotUpPressed()));

	connect(preferencesDialog->mColorsDown , TQT_SIGNAL(pressed()) ,
			this , TQT_SLOT(slotDownPressed()));

	// Connect up all the check boxes
	connect( preferencesDialog->m_lamer, TQT_SIGNAL( clicked() ),
			 this, TQT_SLOT( slotSettingChanged() ) );
	connect( preferencesDialog->m_casewaves, TQT_SIGNAL( clicked() ),
			 this, TQT_SLOT( slotSettingChanged() ) );

	connect( preferencesDialog->m_colorRandom, TQT_SIGNAL( clicked() ),
			 this, TQT_SLOT( slotSettingChanged() ) );
	connect( preferencesDialog->m_fg, TQT_SIGNAL( clicked() ),
			 this, TQT_SLOT( slotSettingChanged() ) );
	connect( preferencesDialog->m_char, TQT_SIGNAL( clicked() ),
			 this, TQT_SLOT( slotSettingChanged() ) );
	connect( preferencesDialog->m_words, TQT_SIGNAL( clicked() ),
			 this, TQT_SLOT( slotSettingChanged() ) );

	//setMainWidget( preferencesDialog, "Text Effect Plugin" );

	load();

}

TextEffectPreferences::~TextEffectPreferences()
{
	delete preferencesDialog;
	delete config;
}


void TextEffectPreferences::load()
{
	kdDebug( 14310 ) << k_funcinfo << "ENTER" << endl;

	config->load();

	preferencesDialog->mColorsListBox->insertStringList(config->colors());
	preferencesDialog->m_fg->setChecked(config->colorLines());
	preferencesDialog->m_words->setChecked(config->colorWords());
	preferencesDialog->m_char->setChecked(config->colorChar());
	preferencesDialog->m_lamer->setChecked(config->lamer());
	preferencesDialog->m_casewaves->setChecked(config->waves());


	// Call parent's save method
	TDECModule::load();

	// Indicate that we have not changed ^_^
	emit changed( false );

	kdDebug( 14310 ) << k_funcinfo << "EXIT" << endl;

}

void TextEffectPreferences::save()
{
	kdDebug() << k_funcinfo << "ENTER" << endl;
	// Save the settings
	config->setColors(colors());
	config->setColorRandom(preferencesDialog->m_colorRandom->isChecked());
	config->setColorLines(preferencesDialog->m_fg->isChecked());
	config->setColorWords(preferencesDialog->m_words->isChecked());
	config->setColorChar(preferencesDialog->m_char->isChecked());

	config->setLamer(preferencesDialog->m_lamer->isChecked());
	config->setWaves(preferencesDialog->m_casewaves->isChecked());

	config->save();

	// Notify the plugin that the settings have changed
	//TextEffectPlugin::plugin()->slotSettingsChanged();

	// Call parent's save method
	TDECModule::save();

	// Indicate that we have not changed ^_^
	emit changed( false );
	kdDebug() << k_funcinfo << "EXIT" << endl;
}

TQStringList TextEffectPreferences::colors()
{
	TQStringList ret;
	for(unsigned int f=0; f<preferencesDialog->mColorsListBox->count() ; f++)
	{
		ret.append(preferencesDialog->mColorsListBox->text(f));
	}
	return ret;
}

void TextEffectPreferences::slotAddPressed()
{
	TQColor myColor;
	if( KColorDialog::getColor( myColor ) == KColorDialog::Accepted )
	{
		preferencesDialog->mColorsListBox->insertItem(TQString(myColor.name()));
	}

	// Indicate that something has changed
	slotSettingChanged();

}
void TextEffectPreferences::slotRemovePressed()
{
	delete preferencesDialog->mColorsListBox->selectedItem();
	// Indicate that something has changed
	slotSettingChanged();
}


void TextEffectPreferences::slotUpPressed()
{
	int p=preferencesDialog->mColorsListBox->currentItem();
	if(p <= 0 )
		return;
	TQListBoxItem *i=preferencesDialog->mColorsListBox->selectedItem();
	if(!i)
		return;
	preferencesDialog->mColorsListBox->setSelected(i,false);
	preferencesDialog->mColorsListBox->takeItem(i);
	preferencesDialog->mColorsListBox->insertItem(i , p-1 );
	preferencesDialog->mColorsListBox->setSelected(i,true);

	// Indicate that something has changed
	slotSettingChanged();

}
void TextEffectPreferences::slotDownPressed()
{
	int p=preferencesDialog->mColorsListBox->currentItem();
	if(p < 0 )
		return;
	TQListBoxItem *i=preferencesDialog->mColorsListBox->selectedItem();
	if(!i)
		return;
	preferencesDialog->mColorsListBox->setSelected(i,false);
	preferencesDialog->mColorsListBox->takeItem(i);
	preferencesDialog->mColorsListBox->insertItem(i , p+1 );
	preferencesDialog->mColorsListBox->setSelected(i,true);

	// Indicate that something has changed
	slotSettingChanged();
}



void TextEffectPreferences::slotSettingChanged()
{
	kdDebug() << k_funcinfo << "Called"
			  << endl;
	// Indicate that our settings have changed
    emit changed( true );
}

void TextEffectPreferences::defaults()
{
    preferencesDialog->mColorsListBox->clear();
    preferencesDialog->mColorsListBox->insertStringList(config->defaultColorList());
    preferencesDialog->m_fg->setChecked(false);
    preferencesDialog->m_words->setChecked(false);
    preferencesDialog->m_char->setChecked(false);
    preferencesDialog->m_lamer->setChecked(false);
    preferencesDialog->m_casewaves->setChecked(false);
    preferencesDialog->m_colorRandom->setChecked( false );
    emit changed( true );
}

#include "texteffectpreferences.moc"
