/*
This file is part of KDE 

  Copyright (C) 1998-2000 Waldo Bastian (bastian@kde.org)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <iostream>

#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdelocale.h>

#include "kcolordialog.h"

static const char description[] =
	I18N_NOOP("TDE Color Chooser");

static const char version[] = "v1.0.1";

static TDECmdLineOptions options[] =
{
   { "print", I18N_NOOP("Print the selected color to stdout"), 0 },
   TDECmdLineLastOption
};
	
int main(int argc, char *argv[])
{
  TDELocale::setMainCatalogue("tdelibs"); 
  TDEAboutData aboutData( "kcolorchooser", I18N_NOOP("KColorChooser"),
		version, description, TDEAboutData::License_BSD,
		"(c) 2000, Waldo Bastian");
  aboutData.addAuthor("Waldo Bastian",0, "bastian@kde.org");
  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( options );

  TDEApplication app;
  
  KColorDialog dlg;

  dlg.setColor(TQt::blue); // Just a color

  app.connect(&dlg, TQT_SIGNAL(finished()), TQT_SLOT(quit()));

  dlg.show();
  app.exec();

  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
  const  TQColor c = dlg.color();
  if ( args->isSet("print") && c.isValid() ) {
      std::cout << TQString(c.name()).utf8().data() << std::endl;
  }
}  
