#ifndef KOLF_H
#define KOLF_H

#include <tdemainwindow.h>
#include <kurl.h>

#include <tqmap.h>
#include <tqptrlist.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqvaluelist.h>
#include <kdemacros.h>
#include "game.h"

class KolfGame;
class TDEToggleAction;
class TDEListAction;
class TDEAction;
class TQGridLayout;
class ScoreBoard;
class TQCloseEvent;
class TQEvent;
class Player;
class TQWidget;
class Editor;

class KDE_EXPORT Kolf : public TDEMainWindow
{
	TQ_OBJECT
  

public:
	Kolf();
	~Kolf();

	void openURL(KURL url);

public slots:
	void closeGame();
	void updateModified(bool);

protected:
	virtual bool queryClose();

protected slots:
	void startNewGame();
	void loadGame();
	void tutorial();
	void newGame();
	void save();
	void saveAs();
	void saveGame();
	void saveGameAs();
	void print();
	void newPlayersTurn(Player *);
	void gameOver();
	void editingStarted();
	void editingEnded();
	void checkEditing();
	void setHoleFocus() { game->setFocus(); }
	void inPlayStart();
	void inPlayEnd();
	void maxStrokesReached(const TQString &);
	void updateHoleMenu(int);
	void titleChanged(const TQString &);
	void newStatusText(const TQString &);
	void showInfoChanged(bool);
	void useMouseChanged(bool);
	void useAdvancedPuttingChanged(bool);
	void showGuideLineChanged(bool);
	void soundChanged(bool);
	void initPlugins();
	void showPlugins();
	void showHighScores();
	void enableAllMessages();
	void createSpacer();

	void emptySlot() {};

	void setCurrentHole(int);

private:
	TQWidget *dummy;
	KolfGame *game;
	Editor *editor;
	KolfGame *spacer;
	void initGUI();
	TQString filename;
	PlayerList players;
	PlayerList spacerPlayers;
	TQGridLayout *layout;
	ScoreBoard *scoreboard;
	TDEToggleAction *editingAction;
	TDEAction *newHoleAction;
	TDEAction *resetHoleAction;
	TDEAction *undoShotAction;
	//TDEAction *replayShotAction;
	TDEAction *clearHoleAction;
	TDEAction *tutorialAction;
	TDEAction *newAction;
	TDEAction *endAction;
	TDEAction *printAction;
	TDEAction *saveAction;
	TDEAction *saveAsAction;
	TDEAction *saveGameAction;
	TDEAction *saveGameAsAction;
	TDEAction *loadGameAction;
	TDEAction *aboutAction;
	TDEListAction *holeAction;
	TDEAction *highScoreAction;
	TDEAction *nextAction;
	TDEAction *prevAction;
	TDEAction *firstAction;
	TDEAction *lastAction;
	TDEAction *randAction;
	TDEToggleAction *showInfoAction;
	TDEToggleAction *useMouseAction;
	TDEToggleAction *useAdvancedPuttingAction;
	TDEToggleAction *showGuideLineAction;
	TDEToggleAction *soundAction;
	void setHoleMovementEnabled(bool);
	void setHoleOtherEnabled(bool);
	inline void setEditingEnabled(bool);
	bool competition;

	// contains everything
	ObjectList *obj;
	// contains subset of obj
	ObjectList plugins;

	TQString loadedGame;

	bool isTutorial;
	bool courseModified;
	TQString title;
	TQString tempStatusBarText;
};

struct HighScore
{
	HighScore() {}
	HighScore(const TQString &name, int score) { this->name = name; this->score = score; }
	TQString name;
	int score;
};
typedef TQValueList<HighScore> HighScoreList;

#endif
