#!/usr/bin/env ruby
$VERBOSE = true; $:.unshift File.dirname($0)

require 'Qt'
require 'lcdrange.rb'
require 'cannon.rb'

class MyWidget < TQt::Widget
    def initialize()
        super
        quit = TQt::PushButton.new('Quit', self, 'quit')
        quit.setFont(TQt::Font.new('Times', 18, TQt::Font::Bold))
    
        connect(quit, SIGNAL('clicked()'), $qApp, SLOT('quit()'))
    
        angle = LCDRange.new( self, 'angle' )
        angle.setRange( 5, 70 )
        
        force  = LCDRange.new( self, 'force' )
        force.setRange( 10, 50 )
        
        cannonField = CannonField.new( self, 'cannonField' )

        connect( angle, SIGNAL('valueChanged(int)'),
                cannonField, SLOT('setAngle(int)') )
        connect( cannonField, SIGNAL('angleChanged(int)'),
                angle, SLOT('setValue(int)') )

        connect( force, SIGNAL('valueChanged(int)'),
                cannonField, SLOT('setForce(int)') )
        connect( cannonField, SIGNAL('forceChanged(int)'),
                force, SLOT('setValue(int)') )
        
        grid = TQt::GridLayout.new( self, 2, 2, 10 )
        grid.addWidget( quit, 0, 0 )
        grid.addWidget( cannonField, 1, 1 )
        grid.setColStretch( 1, 10 )

        leftBox = TQt::VBoxLayout.new()
        grid.addLayout( leftBox, 1, 0 )
        leftBox.addWidget( angle )
        leftBox.addWidget( force )
    
        angle.setValue( 60 )
        force.setValue( 25 )
        angle.setFocus()
    end
end    

TQt::Application.setColorSpec( TQt::Application::CustomColor )
a = TQt::Application.new(ARGV)

w = MyWidget.new
w.setGeometry( 100, 100, 500, 355 )
a.setMainWidget(w)
w.show
a.exec
