#ifndef OPTION_DIALOG_H
#define OPTION_DIALOG_H

#include <kdialogbase.h>

class TQVBoxLayout; 
class TQHBoxLayout; 
class TQGridLayout; 
class TQCheckBox;
class TQLabel;
class TQPushButton;
class TQSpinBox;

class ConfigureDialog : public KDialogBase
{
	TQ_OBJECT

public:
	ConfigureDialog(TQWidget *parent = 0, char *name = 0, bool modal = 0);
	~ConfigureDialog();

signals:
	void clearHistory();
	void valueChanged();

protected slots:
	virtual void slotOk();
	virtual void slotApply();

private slots:
	void readConfig();
	void writeConfig();

private:
	TQSpinBox *PrecNumBox;
	TQSpinBox *NumLevelsNumBox;
	TQCheckBox *BeepBox;
	TQLabel *NumBoxLabel;
	TQCheckBox *FixedCheckBox;
	TQCheckBox *ShowPeriodCheckBox;
	TQLabel *PrecLabel;
	TQLabel *HistoryLabel;
	TQSpinBox *HistDepthBox;
	TQCheckBox *HistDetailCheckBox;
	TQCheckBox *SaveStackCheckBox;
	TQCheckBox *DelDrops;
	TQCheckBox *SaveHistoryCheckBox;
	TQPushButton *ClearHistoryButton;
};

#endif
