/***************************************************************************
                          confdialog.h  -  description
                             -------------------
    begin                : Sun Jan 27 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFDIALOG_H
#define CONFDIALOG_H

// QT includes
#include <tqcheckbox.h>

// KDE includes
#include <kdialogbase.h>
#include <knuminput.h>

#include "guimodeselector.h"

class TQHBoxLayout;
class TQVBoxLayout;
class TQWidget;
class KIntNumInput;
class ConfDialog : public KDialogBase, public GUIModeSelector {
    TQ_OBJECT
  
    public:
        ConfDialog( TQWidget* parent = 0, const char* name = 0 );
        ~ConfDialog();

        inline bool loadplugins() const { return checkPlugins->isChecked(); }
        inline int thumbSize() const { return spinSize->value(); }
        inline bool autosize() const { return checkAutosize->isChecked(); }
        inline int historyItems() const { return spinHistory->value(); }

        inline void setLoadPlugins( bool b ) { checkPlugins->setChecked( b ); }
        inline void setThumbSize( int b ) { spinSize->setValue( b ); }
        inline void setAutosize( bool b ) { checkAutosize->setChecked( b ); }
        inline void setHistoryItems( int b ) { spinHistory->setValue( b ); }
        
    private slots:
        void defaults();

    private:
        void setupTab1();
        void setupTab2();
        
    protected:
        TQCheckBox* checkAsk;
        TQCheckBox* checkPlugins;
        TQCheckBox* checkAutosize;

        KIntNumInput* spinSize;
        KIntNumInput* spinHistory;
};

#endif
