//
// C++ Interface: setupdialogprg
//
// Description: 
//
//
// Author: KoolDock team <radix@kde.cl>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SETUPDIALOGPRG_H
#define SETUPDIALOGPRG_H

#include "setupdialog.h"
#include "apppropprg.h"

// QT includes
#include <tqcolor.h>
#include <tqstring.h>
#include <tqcheckbox.h>
#include <tqlineedit.h>
#include <tqspinbox.h>
#include <tqfont.h>
#include <tqptrlist.h>
#include <tqtabwidget.h>
#include <tqpushbutton.h>
#include <tqradiobutton.h>

// KDE includes
#include <tdefontcombo.h>
#include <kcolorcombo.h>
#include <ktextedit.h>
#include <kdebug.h>
#include <tdeconfig.h>
#include <tdefontdialog.h> 
#include <twinmodule.h>
#include <netwm.h>
#include <klineedit.h>

/**
@author KoolDock team
*/

class KoolDock;

class SetupDialogPrg : public SetupDialog
{
  TQ_OBJECT
  public:
    SetupDialogPrg(TQWidget* parent = 0, const char* name = 0);
    ~SetupDialogPrg();
    appProp* appdlg;
    TQString progPath;
    TQString menuPath;
    KWinModule* gwm;
    KLineEdit* in;
    TQPushButton* up;
    TQPushButton* down;
    int grabbing;
    int oldPos;
    TQString fileName;
    TQStringList fileList;
    TQString filepath;

  public slots:
    void editItem();
    void iconsChanged();
    void configOK();
    void configApply();
    void configCancel();
    void chkHidden();
    void chkImgSlot();
    void chkSolidSlot();
    void chkFont();
    void chkTask();
    void applist_dropped(TQDropEvent*, const TQValueList<TQIconDragItem>&);
    void buttonadd_clicked();
    void applist_clicked(TQIconViewItem*, const TQPoint&);
    void appRestart();
    void appFill();
    void appClear();
    void grabWin_clicked();
    void activeWindowChanged(WId id);
    void applist_contextMenuRequested(TQIconViewItem*, const TQPoint&);
    void removeLauncher();
    void setnewpos(int);
    void xrma_clicked();
    void left();
    void right();
  signals:
    void apply();

  private:
    void computeNewPos(int);
   
  protected:
    void closeEvent(TQCloseEvent*);
    void showEvent(TQShowEvent*);
    void hideEvent(TQHideEvent*);
};

#endif // SETUPDIALOGPRG_H
