/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#include "sigtool.h"


#include <tdelocale.h>
#include <kstatusbar.h>
#include <tdefiledialog.h>



#include <kurlrequester.h>
#include <tqlayout.h>
#include <tdemessagebox.h>
#include <tqtextbrowser.h>

const char *mail_clients[] = {
    "KMail",
    "Evolution",
    0
};

Sigtool::Sigtool(TQWidget *parent, const char *name)
    : TQWidget(parent, name)
{

	TQVBoxLayout *vbox = new TQVBoxLayout(this, KDialog::marginHint(),
		KDialog::spacingHint(), "vbox");
	

	//KMessageBox::information (this,nooffilters);
	TQGroupBox *mail_group = new TQGroupBox(i18n("Email Client"), this);
	vbox->addWidget(mail_group);


	TQGridLayout *mail_layout = new TQGridLayout( mail_group, 2, 6, KDialog::spacingHint(),
			KDialog::spacingHint(), "mail_layout");
	mail_layout->addRowSpacing(0, mail_group->fontMetrics().height());
	mail_layout->setColStretch(1, 1);
	mail_layout->setColStretch(2, 1);

	//IP Address & Port
	TQWidget *mail_hlp = new TQWidget( mail_group );

	mail_layout->addMultiCellWidget(mail_hlp, 1,2, 1,6);
	TQGridLayout *mail_dir_layout = new TQGridLayout(mail_hlp,2,6, KDialog::spacingHint() );

	TQLabel *mail_dir_label = new TQLabel(i18n("Choose your email client:"), mail_hlp);
	mail_dir_label->setAlignment(TQt::AlignRight);
	//mail_dir_label->setFixedSize(mail_dir_label->sizeHint());
	mail_dir_layout->addWidget(mail_dir_label,0,2);
	
	check_combo = new TQComboBox(false, mail_hlp);
	check_combo->insertStrList(mail_clients);
	check_combo->adjustSize();
	//check_combo->setFixedSize(check_combo->size());
	mail_dir_layout->addWidget(check_combo,0,3);

	//User & Pass
// 	TQWidget *mail_hlp2 = new TQWidget( mail_group );
// 	mail_layout->addMultiCellWidget(mail_hlp2, 2,2, 1,2);
// 	TQHBoxLayout *mail_userpass_layout = new TQHBoxLayout(mail_hlp2, KDialog::spacingHint() );

        search_button = new TQPushButton (i18n( "Configure Automatically" ), mail_hlp);
        mail_dir_layout->addWidget(search_button,1,2);
        //search_button->setFixedSize(search_button->sizeHint());
    
        manual_button = new TQPushButton (i18n( "Tell me how to do it" ), mail_hlp);
        mail_dir_layout->addWidget(manual_button,1,3);
        //manual_button->setFixedSize(manual_button->sizeHint());


// 	KButtonBox *actionbox = new KButtonBox(mail_hlp, TQt::Horizontal);
// 	mail_userpass_layout->addWidget(actionbox);
// 	actionbox->addStretch();
// 	search_button = actionbox->addButton(i18n("&Configure Automatically"));
// 	manual_button = actionbox->addButton(i18n("&Tell me how to do it"));
// 	actionbox->addStretch();
// 	actionbox->layout();


	
	const TQString text = i18n( "This will help you configure your email client to scan incoming and outgoing mail with KlamAV. Not all mail clients are fully supported yet. Infected mail is clearly marked as such and is wrapped in another email from KlamAV telling you the name of the virus and other relevant details." );
	
	TQGroupBox *Notes = new TQGroupBox(i18n("Notes"), this);
	vbox->addWidget(Notes);
	
	TQGridLayout *notes_layout = new TQGridLayout( Notes, 5, 2, KDialog::spacingHint(),
			KDialog::spacingHint(), "notes_layout");
	notes_layout->addRowSpacing(0, Notes->fontMetrics().height());
	notes_layout->setColStretch(0, 1);
	notes_layout->setColStretch(1, 1);


	TQWidget *notes_hlp = new TQWidget( Notes );

	notes_layout->addMultiCellWidget(notes_hlp, 1,1, 0,1);
	TQHBoxLayout *notes_box = new TQHBoxLayout(notes_hlp, KDialog::spacingHint() );
	
	notes_browser = new TQTextBrowser(notes_hlp);
	notes_browser->setText(text);
	notes_browser->setAlignment( TQt::AlignCenter );
	notes_box->addWidget(notes_browser);

	


	
	
	connect( search_button, SIGNAL(clicked()),
		SLOT(configureKMail()) );
	connect( manual_button, SIGNAL(clicked()),
		SLOT(manual()) );
	connect( check_combo, SIGNAL(activated(const TQString &)),
		SLOT(dobuttons()) );

		


}

Sigtool::~Sigtool()
{
}


void  Sigtool::configureKMail(){

	KMessageBox::information (this,i18n( "Please ensure KMail is not open before we proceed.") );
	
	TQString DatabaseLocation;
	config = TDEGlobal::config();
	config->setGroup("Freshklam");
	TQStringList lastDownloadPaths = config->readListEntry("lastDownloadPaths");
	for (TQStringList::Iterator it = lastDownloadPaths.begin(); it == lastDownloadPaths.begin() ; it++){
			DatabaseLocation = *it;
	}

	config = new TDEConfig("kmailrc");
	config->setGroup("General");
	TQVariant nooffilters = config->readEntry("filters");
	
	int numfilters = nooffilters.toInt();
	nooffilters = numfilters;
	for (int j=0; j != numfilters; j++ ){
		TQVariant numb = j;
		TQString filtername=TQString("Filter #%1").arg(numb.toString());
		config->setGroup(filtername);
		TQString binary = config->readEntry("action-args-0");
		if (binary.find("klammail") != -1){
				KMessageBox::information (this,i18n( "You're already set up! Sure you haven't already configured KMail for KlamAV scanning?") );
				return;
		}
	}

	
	TQString filtername=TQString("Filter #%1").arg(nooffilters.toString());
	config->setGroup(filtername);
	
	config->writeEntry("ConfigureShortcut", "false");
	config->writeEntry("Icon", "");
	config->writeEntry("StopProcessingHere","false");
	config->writeEntry("action-args-0", TQString("klammail -d %1").arg(DatabaseLocation));
	config->writeEntry("action-name-0","filter app");
	config->writeEntry("actions","1");
	config->writeEntry("apply-on","check-mail","manual-filtering");
	config->writeEntry("contentsA","2");
	config->writeEntry("fieldA","<size>");
	config->writeEntry("funcA","greater-or-equal");
	config->writeEntry("name","<<size>>:2");
	config->writeEntry("operator","or");
	config->writeEntry("rules","1");

	numfilters++;
	nooffilters = numfilters;
	filtername=TQString("Filter #%1").arg(nooffilters.toString());
	config->setGroup(filtername);

	config->writeEntry("ConfigureShortcut","false");
	config->writeEntry("Icon", "");
	config->writeEntry("StopProcessingHere","false");
	config->writeEntry("action-args-0","trash");
	config->writeEntry("action-name-0","transfer");
	config->writeEntry("actions","1");
	config->writeEntry("apply-on","check-mail","manual-filtering");
	config->writeEntry("contentsA","virus-found");
	config->writeEntry("fieldA","<any header>");
	config->writeEntry("funcA","contains");
	config->writeEntry("name","<<any header>>:virus-found");
	config->writeEntry("operator","or");
	config->writeEntry("rules","1");

	numfilters ++;
	nooffilters = numfilters;
	config->setGroup("General");
	config->writeEntry("filters", nooffilters.toString());
	config->sync();
	
	KMessageBox::information (this,i18n( "I've set up the filters as the last two in your KMail filter list. You might want to open Kmail up and take a look.") );
}

void  Sigtool::manualKMail(){


	const TQString text = i18n( "Mail scanning support is provided by a program called 'klammail'. This was installed automatically as part of the KlamAV installation. To use this program to scan your email as you send and receive it you need to set up a 'filter' in KMail to 'pipe' mail through klammail as it is coming in/going out. You should then set up a filter after this one to put any mail with the word 'virus-found' in the header into the quarantine folder of your choice. The mail will be clearly marked as infected and will tell you the name of the virus and who the mail is from." );

	notes_browser->setText( text );

	
}

void  Sigtool::manualEvolution(){

	const TQString text = i18n( "Mail scanning support is provided by a program called 'klammail'. This was installed automatically as part of the KlamAV installation. To use this program to scan your email as you send and receive it you need to set up a 'filter' in Evolution to 'pipe' mail through klammail as it is coming in/going out. You should then set up a filter after this one to put any mail with the word 'virus-found' in the header into the quarantine folder of your choice. The mail will be clearly marked as infected and will tell you the name of the virus and who the mail is from." );

	notes_browser->setText( text );
	notes_browser->setAlignment( TQt::AlignCenter );

	
}

void  Sigtool::manual(){

	
	switch (check_combo->currentItem()) {
        case 0 : manualKMail();break;
        case 1 : manualEvolution(); break;
	}


	
}

void  Sigtool::dobuttons(){

	//KMessageBox::information (this,check_combo->currentItem());
	switch (check_combo->currentItem()) {
        case 0 : search_button->setEnabled(true);;break;
        case 1 : search_button->setEnabled(false);; break;
	}


	
}

#include "sigtool.moc"
