//**************************************************************************
//   Copyright (C) 2004, 2005 by Petri Damstn
//   petri.damsten@iki.fi
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the
//   Free Software Foundation, Inc.,
//   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//**************************************************************************

#include "kbfxfontchooser.h"

KBFXFontChooser::KBFXFontChooser ( TQWidget *parent, const char *name )
		: TQWidget ( parent, name )
{
	TQHBoxLayout* layout = new TQHBoxLayout ( this, 0, KDialog::spacingHint() );

	m_label = new TQLabel ( this, "fontLabel" );
	m_label->setSizePolicy ( TQSizePolicy::Expanding,  TQSizePolicy::Fixed, TRUE);
//	m_label->setFrameShape ( TQFrame::StyledPanel );
//	m_label->setFrameShadow ( TQFrame::Sunken );

	layout->addWidget ( m_label );

	m_button = new TQPushButton ( this, "fontButton" );
	m_label->setMaximumHeight ( m_button -> height() );
	m_label->setMinimumHeight ( m_button -> height() );
	TQString fontText = i18n ( "Font..." );
//	m_button->setSizePolicy ( TQSizePolicy::Minimum,  TQSizePolicy::Minimum, TRUE);
	m_button->setText ( fontText );
	TQIconSet iconSet = SmallIconSet ( TQString::fromLatin1 ( "fonts" ) );
	TQPixmap pixmap = iconSet.pixmap ( TQIconSet::Small, TQIconSet::Normal );
	m_button->setIconSet ( iconSet );
	m_button->setFixedWidth ( m_button->fontMetrics().width ( fontText ) +
	                          3 * KDialog::spacingHint() + pixmap.width() );
	layout->addWidget ( m_button );

	connect ( m_button, TQT_SIGNAL ( clicked() ), this, TQT_SLOT ( buttonClicked() ) );

	updateFontLabel();

	setFocusProxy ( m_button );
}

KBFXFontChooser::~KBFXFontChooser()
{}

void KBFXFontChooser::setFont ( const TQFont& font )
{
	m_font = font;
	updateFontLabel();
}

void KBFXFontChooser::updateFontLabel()
{
	TQString s = TQString ( "%1 (%2pt) " ).arg ( m_font.family() ).arg ( m_font.pointSize() );
	m_label->setFont ( m_font );
	m_label->setText ( s );
	m_label->setAlignment ( TQt::AlignLeft | TQt::AlignVCenter );
	emit FontChanged();
}

void KBFXFontChooser::buttonClicked()
{
	TDEFontDialog::getFont ( m_font );
	updateFontLabel();
}

#include "kbfxfontchooser.moc"
